/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.springframework.beans.Mergeable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.SmartRequestBuilder;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

final class HtmlUnitRequestBuilder
implements RequestBuilder,
Mergeable {
    private final Map<String, MockHttpSession> sessions;
    private final CookieManager cookieManager;
    private final WebRequest webRequest;
    private String contextPath;
    private RequestBuilder parentBuilder;
    private SmartRequestBuilder parentPostProcessor;
    private RequestPostProcessor forwardPostProcessor;
    private static final Pattern LOCALE_PATTERN = Pattern.compile("^\\s*(\\w{2})(?:-(\\w{2}))?(?:;q=(\\d+\\.\\d+))?$");

    public HtmlUnitRequestBuilder(Map<String, MockHttpSession> sessions, CookieManager cookieManager, WebRequest webRequest) {
        Assert.notNull(sessions, (String)"sessions cannot be null");
        Assert.notNull((Object)cookieManager, (String)"cookieManager");
        Assert.notNull((Object)webRequest, (String)"webRequest cannot be null");
        this.sessions = sessions;
        this.cookieManager = cookieManager;
        this.webRequest = webRequest;
    }

    public MockHttpServletRequest buildRequest(ServletContext servletContext) {
        String charset = this.getCharset();
        String httpMethod = this.webRequest.getHttpMethod().name();
        UriComponents uriComponents = this.uriComponents();
        HtmlUnitMockHttpServletRequest result = new HtmlUnitMockHttpServletRequest(servletContext, httpMethod, uriComponents.getPath());
        this.parent(result, this.parentBuilder);
        result.setServerName(uriComponents.getHost());
        this.authType(result);
        result.setCharacterEncoding(charset);
        this.content(result, charset);
        this.contextPath(result, uriComponents);
        this.contentType(result);
        this.cookies(result);
        this.headers(result);
        this.locales(result);
        this.servletPath(uriComponents, result);
        this.params(result, uriComponents);
        this.ports(uriComponents, result);
        result.setProtocol("HTTP/1.1");
        result.setQueryString(uriComponents.getQuery());
        result.setScheme(uriComponents.getScheme());
        this.pathInfo(uriComponents, result);
        return this.postProcess(result);
    }

    private MockHttpServletRequest postProcess(MockHttpServletRequest request) {
        if (this.parentPostProcessor != null) {
            request = this.parentPostProcessor.postProcessRequest(request);
        }
        if (this.forwardPostProcessor != null) {
            request = this.forwardPostProcessor.postProcessRequest(request);
        }
        return request;
    }

    private void parent(MockHttpServletRequest result, RequestBuilder parent) {
        String attrName;
        if (parent == null) {
            return;
        }
        MockHttpServletRequest parentRequest = parent.buildRequest(result.getServletContext());
        HttpSession parentSession = parentRequest.getSession(false);
        if (parentSession != null) {
            Enumeration attrNames = parentSession.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                attrName = (String)attrNames.nextElement();
                Object attrValue = parentSession.getAttribute(attrName);
                result.getSession().setAttribute(attrName, attrValue);
            }
        }
        Enumeration headerNames = parentRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            attrName = (String)headerNames.nextElement();
            Enumeration attrValues = parentRequest.getHeaders(attrName);
            while (attrValues.hasMoreElements()) {
                String string = (String)attrValues.nextElement();
                result.addHeader(attrName, (Object)string);
            }
        }
        Map parentParams = parentRequest.getParameterMap();
        for (Map.Entry entry : parentParams.entrySet()) {
            String paramName = (String)entry.getKey();
            String[] paramValues = (String[])entry.getValue();
            result.addParameter(paramName, paramValues);
        }
        javax.servlet.http.Cookie[] parentCookies = parentRequest.getCookies();
        if (parentCookies != null) {
            result.setCookies(parentCookies);
        }
        Enumeration enumeration = parentRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String parentAttrName = (String)enumeration.nextElement();
            result.setAttribute(parentAttrName, parentRequest.getAttribute(parentAttrName));
        }
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null || "".equals(contextPath)) {
            this.contextPath = contextPath;
            return;
        }
        if (contextPath.endsWith("/")) {
            throw new IllegalArgumentException("contextPath cannot end with /. Got '" + contextPath + "'");
        }
        if (!contextPath.startsWith("/")) {
            throw new IllegalArgumentException("contextPath must start with /. Got '" + contextPath + "'");
        }
        this.contextPath = contextPath;
    }

    public void setForwardPostProcessor(RequestPostProcessor postProcessor) {
        this.forwardPostProcessor = postProcessor;
    }

    private void authType(MockHttpServletRequest request) {
        String authorization = this.header("Authorization");
        if (authorization != null) {
            String[] authzParts = authorization.split(": ");
            request.setAuthType(authzParts[0]);
        }
    }

    private void content(MockHttpServletRequest result, String charset) {
        String requestBody = this.webRequest.getRequestBody();
        if (requestBody == null) {
            return;
        }
        try {
            result.setContent(requestBody.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void contentType(MockHttpServletRequest result) {
        String contentType = this.header("Content-Type");
        result.setContentType(contentType == null ? "*/*".toString() : contentType);
    }

    private void contextPath(MockHttpServletRequest result, UriComponents uriComponents) {
        if (this.contextPath == null) {
            List pathSegments = uriComponents.getPathSegments();
            if (pathSegments.isEmpty()) {
                result.setContextPath("");
            } else {
                result.setContextPath("/" + (String)pathSegments.get(0));
            }
        } else {
            if (!uriComponents.getPath().startsWith(this.contextPath)) {
                throw new IllegalArgumentException(uriComponents.getPath() + " should start with contextPath " + this.contextPath);
            }
            result.setContextPath(this.contextPath);
        }
    }

    private void cookies(MockHttpServletRequest result) {
        String cookieHeaderValue = this.header("Cookie");
        javax.servlet.http.Cookie[] parentCookies = result.getCookies();
        ArrayList<javax.servlet.http.Cookie> cookies = new ArrayList<javax.servlet.http.Cookie>();
        if (cookieHeaderValue != null) {
            StringTokenizer tokens = new StringTokenizer(cookieHeaderValue, "=;");
            while (tokens.hasMoreTokens()) {
                String cookieName = tokens.nextToken().trim();
                if (!tokens.hasMoreTokens()) {
                    throw new IllegalArgumentException("Expected value for cookie name " + cookieName + ". Full cookie was " + cookieHeaderValue);
                }
                String cookieValue = tokens.nextToken().trim();
                this.processCookie(result, cookies, new javax.servlet.http.Cookie(cookieName, cookieValue));
            }
        }
        Set managedCookies = this.cookieManager.getCookies(this.webRequest.getUrl());
        for (Cookie cookie : managedCookies) {
            this.processCookie(result, cookies, new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue()));
        }
        if (parentCookies != null) {
            for (javax.servlet.http.Cookie cookie : parentCookies) {
                cookies.add(cookie);
            }
        }
        if (!cookies.isEmpty()) {
            result.setCookies(cookies.toArray(new javax.servlet.http.Cookie[0]));
        }
    }

    private void processCookie(MockHttpServletRequest result, List<javax.servlet.http.Cookie> cookies, javax.servlet.http.Cookie cookie) {
        cookies.add(cookie);
        if ("JSESSIONID".equals(cookie.getName())) {
            result.setRequestedSessionId(cookie.getValue());
            result.setSession((HttpSession)this.httpSession(result, cookie.getValue()));
        }
    }

    private String getCharset() {
        String charset = this.webRequest.getCharset();
        if (charset == null) {
            return "ISO-8859-1";
        }
        return charset;
    }

    private String header(String headerName) {
        return (String)this.webRequest.getAdditionalHeaders().get(headerName);
    }

    private void headers(MockHttpServletRequest result) {
        for (Map.Entry header : this.webRequest.getAdditionalHeaders().entrySet()) {
            result.addHeader((String)header.getKey(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MockHttpSession httpSession(MockHttpServletRequest request, String sessionid) {
        MockHttpSession session;
        Map<String, MockHttpSession> map = this.sessions;
        synchronized (map) {
            session = this.sessions.get(sessionid);
            if (session == null) {
                session = new HtmlUnitMockHttpSession(request, sessionid);
                session.setNew(true);
                Map<String, MockHttpSession> map2 = this.sessions;
                synchronized (map2) {
                    this.sessions.put(sessionid, session);
                }
                this.addSessionCookie(request, sessionid);
            } else {
                session.setNew(false);
            }
        }
        return session;
    }

    private void addSessionCookie(MockHttpServletRequest request, String sessionid) {
        this.cookieManager.addCookie(this.createCookie(request, sessionid));
    }

    private void removeSessionCookie(MockHttpServletRequest request, String sessionid) {
        this.cookieManager.removeCookie(this.createCookie(request, sessionid));
    }

    private Cookie createCookie(MockHttpServletRequest request, String sessionid) {
        return new Cookie(request.getServerName(), "JSESSIONID", sessionid, request.getContextPath() + "/", null, request.isSecure(), true);
    }

    private void locales(MockHttpServletRequest result) {
        String locale = this.header("Accept-Language");
        if (locale == null) {
            result.addPreferredLocale(Locale.getDefault());
        } else {
            String[] locales = locale.split(", ");
            for (int i = locales.length - 1; i >= 0; --i) {
                result.addPreferredLocale(this.parseLocale(locales[i]));
            }
        }
    }

    private void params(MockHttpServletRequest result, UriComponents uriComponents) {
        for (Map.Entry values : uriComponents.getQueryParams().entrySet()) {
            String name = (String)values.getKey();
            for (String value : (List)values.getValue()) {
                try {
                    result.addParameter(name, URLDecoder.decode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        for (NameValuePair param : this.webRequest.getRequestParameters()) {
            result.addParameter(param.getName(), param.getValue());
        }
    }

    private Locale parseLocale(String locale) {
        String qualifier;
        Matcher matcher = LOCALE_PATTERN.matcher(locale);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid locale " + locale);
        }
        String language = matcher.group(1);
        String country = matcher.group(2);
        if (country == null) {
            country = "";
        }
        if ((qualifier = matcher.group(3)) == null) {
            qualifier = "";
        }
        return new Locale(language, country, qualifier);
    }

    private void pathInfo(UriComponents uriComponents, MockHttpServletRequest result) {
        result.setPathInfo(null);
    }

    private void servletPath(MockHttpServletRequest result, String requestPath) {
        String servletPath = requestPath.substring(result.getContextPath().length());
        if ("".equals(servletPath)) {
            servletPath = null;
        }
        result.setServletPath(servletPath);
    }

    private void servletPath(UriComponents uriComponents, MockHttpServletRequest result) {
        if ("".equals(result.getPathInfo())) {
            result.setPathInfo(null);
        }
        this.servletPath(result, uriComponents.getPath());
    }

    private void ports(UriComponents uriComponents, MockHttpServletRequest result) {
        int serverPort = uriComponents.getPort();
        result.setServerPort(serverPort);
        if (serverPort == -1) {
            int portConnection = this.webRequest.getUrl().getDefaultPort();
            result.setLocalPort(serverPort);
            result.setRemotePort(portConnection);
        } else {
            result.setRemotePort(serverPort);
        }
    }

    private UriComponents uriComponents() {
        URL url = this.webRequest.getUrl();
        UriComponentsBuilder uriBldr = UriComponentsBuilder.fromUriString((String)url.toExternalForm());
        return uriBldr.build();
    }

    public boolean isMergeEnabled() {
        return true;
    }

    public Object merge(Object parent) {
        if (parent == null) {
            return this;
        }
        if (parent instanceof RequestBuilder) {
            this.parentBuilder = (RequestBuilder)parent;
        }
        if (parent instanceof SmartRequestBuilder) {
            this.parentPostProcessor = (SmartRequestBuilder)parent;
        }
        return this;
    }

    private final class HtmlUnitMockHttpSession
    extends MockHttpSession {
        private final MockHttpServletRequest request;

        private HtmlUnitMockHttpSession(MockHttpServletRequest request) {
            super(request.getServletContext());
            this.request = request;
        }

        private HtmlUnitMockHttpSession(MockHttpServletRequest request, String id) {
            super(request.getServletContext(), id);
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            super.invalidate();
            Map map = HtmlUnitRequestBuilder.this.sessions;
            synchronized (map) {
                HtmlUnitRequestBuilder.this.sessions.remove(this.getId());
            }
            HtmlUnitRequestBuilder.this.removeSessionCookie(this.request, this.getId());
        }
    }

    private final class HtmlUnitMockHttpServletRequest
    extends MockHttpServletRequest {
        private HtmlUnitMockHttpServletRequest(ServletContext servletContext, String method, String requestURI) {
            super(servletContext, method, requestURI);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpSession getSession(boolean create) {
            Object result = super.getSession(false);
            if (result == null && create) {
                HtmlUnitMockHttpSession newSession = new HtmlUnitMockHttpSession((MockHttpServletRequest)this);
                this.setSession((HttpSession)newSession);
                newSession.setNew(true);
                String sessionid = newSession.getId();
                Map map = HtmlUnitRequestBuilder.this.sessions;
                synchronized (map) {
                    HtmlUnitRequestBuilder.this.sessions.put(sessionid, newSession);
                }
                HtmlUnitRequestBuilder.this.addSessionCookie(this, sessionid);
                result = newSession;
            }
            return result;
        }

        public HttpSession getSession() {
            return super.getSession();
        }

        public void setSession(HttpSession session) {
            super.setSession(session);
        }
    }
}

