/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.security;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.expression.WebSecurityExpressionHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthorizeTag {
    private String access;
    private String url;
    private String method;
    private String ifAllGranted;
    private String ifAnyGranted;
    private String ifNotGranted;

    protected abstract ServletRequest getRequest();

    protected abstract ServletResponse getResponse();

    protected abstract ServletContext getServletContext();

    public boolean authorize() throws IOException {
        boolean isAuthorized = false;
        isAuthorized = StringUtils.hasText((String)this.getAccess()) ? this.authorizeUsingAccessExpression() : (StringUtils.hasText((String)this.getUrl()) ? this.authorizeUsingUrlCheck() : this.authorizeUsingGrantedAuthorities());
        return isAuthorized;
    }

    public boolean authorizeUsingGrantedAuthorities() {
        Set<GrantedAuthority> grantedCopy;
        boolean hasTextAllGranted = StringUtils.hasText((String)this.getIfAllGranted());
        boolean hasTextAnyGranted = StringUtils.hasText((String)this.getIfAnyGranted());
        boolean hasTextNotGranted = StringUtils.hasText((String)this.getIfNotGranted());
        if (!(hasTextAllGranted || hasTextAnyGranted || hasTextNotGranted)) {
            return false;
        }
        Collection<GrantedAuthority> granted = this.getPrincipalAuthorities();
        if (hasTextAllGranted && !granted.containsAll(this.parseAuthoritiesString(this.getIfAllGranted()))) {
            return false;
        }
        if (hasTextAnyGranted && (grantedCopy = this.retainAll(granted, this.parseAuthoritiesString(this.getIfAnyGranted()))).isEmpty()) {
            return false;
        }
        return !hasTextNotGranted || (grantedCopy = this.retainAll(granted, this.parseAuthoritiesString(this.getIfNotGranted()))).isEmpty();
    }

    public boolean authorizeUsingAccessExpression() throws IOException {
        Expression accessExpression;
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (currentUser == null) {
            return false;
        }
        WebSecurityExpressionHandler handler = this.getExpressionHandler();
        try {
            accessExpression = handler.getExpressionParser().parseExpression(this.getAccess());
        }
        catch (ParseException e) {
            IOException ioException = new IOException();
            ioException.initCause(e);
            throw ioException;
        }
        FilterInvocation f = new FilterInvocation(this.getRequest(), this.getResponse(), new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                throw new UnsupportedOperationException();
            }
        });
        return ExpressionUtils.evaluateAsBoolean((Expression)accessExpression, (EvaluationContext)handler.createEvaluationContext(currentUser, f));
    }

    public boolean authorizeUsingUrlCheck() throws IOException {
        String contextPath = ((HttpServletRequest)this.getRequest()).getContextPath();
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        return this.getPrivilegeEvaluator().isAllowed(contextPath, this.getUrl(), this.getMethod(), currentUser);
    }

    public String getAccess() {
        return this.access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method != null ? method.toUpperCase() : null;
    }

    public String getIfAllGranted() {
        return this.ifAllGranted;
    }

    public void setIfAllGranted(String ifAllGranted) {
        this.ifAllGranted = ifAllGranted;
    }

    public String getIfAnyGranted() {
        return this.ifAnyGranted;
    }

    public void setIfAnyGranted(String ifAnyGranted) {
        this.ifAnyGranted = ifAnyGranted;
    }

    public String getIfNotGranted() {
        return this.ifNotGranted;
    }

    public void setIfNotGranted(String ifNotGranted) {
        this.ifNotGranted = ifNotGranted;
    }

    private Collection<GrantedAuthority> getPrincipalAuthorities() {
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (currentUser == null) {
            return Collections.emptyList();
        }
        return currentUser.getAuthorities();
    }

    private Set<GrantedAuthority> parseAuthoritiesString(String authorizationsString) {
        HashSet<GrantedAuthority> requiredAuthorities = new HashSet<GrantedAuthority>();
        requiredAuthorities.addAll(AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorizationsString));
        return requiredAuthorities;
    }

    private Set<GrantedAuthority> retainAll(Collection<GrantedAuthority> granted, Set<GrantedAuthority> required) {
        Set<String> grantedRoles = this.authoritiesToRoles(granted);
        Set<String> requiredRoles = this.authoritiesToRoles(required);
        grantedRoles.retainAll(requiredRoles);
        return this.rolesToAuthorities(grantedRoles, granted);
    }

    private Set<String> authoritiesToRoles(Collection<GrantedAuthority> c) {
        HashSet<String> target = new HashSet<String>();
        for (GrantedAuthority authority : c) {
            if (authority.getAuthority() == null) {
                throw new IllegalArgumentException("Cannot process GrantedAuthority objects which return null from getAuthority() - attempting to process " + authority.toString());
            }
            target.add(authority.getAuthority());
        }
        return target;
    }

    private Set<GrantedAuthority> rolesToAuthorities(Set<String> grantedRoles, Collection<GrantedAuthority> granted) {
        HashSet<GrantedAuthority> target = new HashSet<GrantedAuthority>();
        block0: for (String role : grantedRoles) {
            for (GrantedAuthority authority : granted) {
                if (!authority.getAuthority().equals(role)) continue;
                target.add(authority);
                continue block0;
            }
        }
        return target;
    }

    private WebSecurityExpressionHandler getExpressionHandler() throws IOException {
        WebApplicationContext appContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        Map expressionHandlres = appContext.getBeansOfType(WebSecurityExpressionHandler.class);
        if (expressionHandlres.size() == 0) {
            throw new IOException("No visible WebSecurityExpressionHandler instance could be found in the application context. There must be at least one in order to support expressions in JSP 'authorize' tags.");
        }
        return (WebSecurityExpressionHandler)expressionHandlres.values().toArray()[0];
    }

    private WebInvocationPrivilegeEvaluator getPrivilegeEvaluator() throws IOException {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        Map wipes = ctx.getBeansOfType(WebInvocationPrivilegeEvaluator.class);
        if (wipes.size() == 0) {
            throw new IOException("No visible WebInvocationPrivilegeEvaluator instance could be found in the application context. There must be at least one in order to support the use of URL access checks in 'authorize' tags.");
        }
        return (WebInvocationPrivilegeEvaluator)wipes.values().toArray()[0];
    }
}

