/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow.context.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.binding.collection.MapAdaptable;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.faces.webflow.context.portlet.InitParameterMap;
import org.springframework.faces.webflow.context.portlet.RequestParameterMap;
import org.springframework.faces.webflow.context.portlet.RequestPropertyMap;
import org.springframework.util.Assert;
import org.springframework.webflow.context.portlet.PortletContextMap;
import org.springframework.webflow.context.portlet.PortletRequestMap;
import org.springframework.webflow.context.portlet.PortletSessionMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.core.collection.LocalAttributeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletExternalContextImpl
extends ExternalContext {
    private ActionRequest actionRequest;
    private Map<String, Object> applicationMap;
    private boolean isActionRequest;
    private PortletContext portletContext;
    private PortletRequest portletRequest;
    private PortletResponse portletResponse;
    private Map<String, String> initParameterMap;
    private Map<String, String> requestHeaderMap;
    private Map<String, String[]> requestHeaderValuesMap;
    private Map<String, Object> requestMap;
    private Map<String, String> requestParameterMap;
    private Map<String, String[]> requestParameterValuesMap;
    private MapAdaptable sessionMap;

    public PortletExternalContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this.portletContext = portletContext;
        this.portletRequest = portletRequest;
        this.portletResponse = portletResponse;
        if (portletRequest instanceof ActionRequest) {
            this.actionRequest = (ActionRequest)portletRequest;
            this.isActionRequest = true;
        }
    }

    public void dispatch(String path) throws IOException {
        Assert.isTrue((!this.isActionRequest ? 1 : 0) != 0);
        PortletRequestDispatcher requestDispatcher = this.portletContext.getRequestDispatcher(path);
        try {
            requestDispatcher.include((RenderRequest)this.portletRequest, (RenderResponse)this.portletResponse);
        }
        catch (PortletException exception) {
            if (exception.getMessage() != null) {
                throw new FacesException(exception.getMessage(), (Throwable)exception);
            }
            throw new FacesException((Throwable)exception);
        }
    }

    public String encodeActionURL(String url) {
        Assert.notNull((Object)url);
        return this.portletResponse.encodeURL(url);
    }

    public String encodeNamespace(String name) {
        Assert.isTrue((!this.isActionRequest ? 1 : 0) != 0);
        return String.valueOf(name) + ((RenderResponse)this.portletResponse).getNamespace();
    }

    public String encodeResourceURL(String url) {
        Assert.notNull((Object)url);
        return this.portletResponse.encodeURL(url);
    }

    public Map<String, Object> getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new PortletContextMap(this.portletContext);
        }
        return this.applicationMap;
    }

    public String getAuthType() {
        return this.portletRequest.getAuthType();
    }

    public Object getContext() {
        return this.portletContext;
    }

    public String getInitParameter(String name) {
        return this.portletContext.getInitParameter(name);
    }

    public Map<String, String> getInitParameterMap() {
        if (this.initParameterMap == null) {
            this.initParameterMap = new InitParameterMap(this.portletContext);
        }
        return this.initParameterMap;
    }

    public String getRemoteUser() {
        return this.portletRequest.getRemoteUser();
    }

    public Object getRequest() {
        return this.portletRequest;
    }

    public String getRequestContentType() {
        return null;
    }

    public String getRequestContextPath() {
        return this.portletRequest.getContextPath();
    }

    public Map<String, Object> getRequestCookieMap() {
        return Collections.EMPTY_MAP;
    }

    public Map<String, String> getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            RequestPropertyMap map = new RequestPropertyMap(this.portletRequest);
            map.setUseArrayForMultiValueAttributes(Boolean.FALSE);
            this.requestHeaderMap = map;
        }
        return this.requestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this.requestHeaderValuesMap == null) {
            RequestPropertyMap map = new RequestPropertyMap(this.portletRequest);
            map.setUseArrayForMultiValueAttributes(Boolean.TRUE);
            this.requestHeaderValuesMap = map;
        }
        return this.requestHeaderValuesMap;
    }

    public Locale getRequestLocale() {
        return this.portletRequest.getLocale();
    }

    public Iterator<Locale> getRequestLocales() {
        return CollectionUtils.toIterator((Enumeration)this.portletRequest.getLocales());
    }

    public Map<String, Object> getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new PortletRequestMap(this.portletRequest);
        }
        return this.requestMap;
    }

    public Map<String, String> getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            RequestParameterMap map = new RequestParameterMap(this.portletRequest);
            map.setUseArrayForMultiValueAttributes(Boolean.FALSE);
            this.requestParameterMap = map;
        }
        return this.requestParameterMap;
    }

    public Iterator<String> getRequestParameterNames() {
        return CollectionUtils.toIterator((Enumeration)this.portletRequest.getParameterNames());
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap == null) {
            RequestParameterMap map = new RequestParameterMap(this.portletRequest);
            map.setUseArrayForMultiValueAttributes(Boolean.TRUE);
            this.requestParameterValuesMap = map;
        }
        return this.requestParameterValuesMap;
    }

    public String getRequestPathInfo() {
        return null;
    }

    public String getRequestServletPath() {
        return JsfRuntimeInformation.isMyFacesPresent() ? "" : null;
    }

    public URL getResource(String path) throws MalformedURLException {
        Assert.notNull((Object)path);
        return this.portletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        Assert.notNull((Object)path);
        return this.portletContext.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        Assert.notNull((Object)path);
        return this.portletContext.getResourcePaths(path);
    }

    public Object getResponse() {
        return this.portletResponse;
    }

    public String getResponseContentType() {
        return null;
    }

    public Object getSession(boolean create) {
        return this.portletRequest.getPortletSession(create);
    }

    public Map<String, Object> getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new LocalAttributeMap((Map)new PortletSessionMap(this.portletRequest));
        }
        return this.sessionMap.asMap();
    }

    public Principal getUserPrincipal() {
        return this.portletRequest.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        Assert.notNull((Object)role);
        return this.portletRequest.isUserInRole(role);
    }

    public void log(String message) {
        Assert.notNull((Object)message);
        this.portletContext.log(message);
    }

    public void log(String message, Throwable exception) {
        Assert.notNull((Object)message);
        Assert.notNull((Object)exception);
        this.portletContext.log(message, exception);
    }

    public void redirect(String url) throws IOException {
        if (!(this.actionRequest instanceof ActionResponse)) {
            throw new IllegalArgumentException("Only ActionResponse supported");
        }
        ((ActionResponse)this.portletResponse).sendRedirect(url);
    }

    public void release() {
        this.portletContext = null;
        this.portletRequest = null;
        this.portletResponse = null;
        this.applicationMap = null;
        this.sessionMap = null;
        this.requestMap = null;
        this.requestParameterMap = null;
        this.requestParameterValuesMap = null;
        this.requestHeaderMap = null;
        this.requestHeaderValuesMap = null;
        this.initParameterMap = null;
        this.actionRequest = null;
    }

    public void setRequest(Object request) {
        this.portletRequest = (PortletRequest)request;
        this.actionRequest = this.portletRequest instanceof ActionRequest ? (ActionRequest)request : null;
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        Assert.notNull((Object)this.actionRequest, (String)"The request be an action request.");
        this.actionRequest.setCharacterEncoding(encoding);
    }

    public String getRequestCharacterEncoding() {
        Assert.notNull((Object)this.actionRequest, (String)"The request be an action request.");
        return this.actionRequest.getCharacterEncoding();
    }

    public String getResponseCharacterEncoding() {
        return null;
    }

    public void setResponseCharacterEncoding(String encoding) {
    }

    public void setResponse(Object response) {
        this.portletResponse = (PortletResponse)response;
    }
}

