/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class FacesFlowBuilderServicesBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String FACES_CONVERSION_SERVICE_CLASS_NAME = "org.springframework.faces.model.converter.FacesConversionService";
    private static final String FLOW_BUILDER_SERVICES_CLASS_NAME = "org.springframework.webflow.engine.builder.support.FlowBuilderServices";
    private static final String JSF_VIEW_FACTORY_CREATOR_CLASS_NAME = "org.springframework.faces.webflow.JsfViewFactoryCreator";
    private static final String FACES_SPRING_EL_EXPRESSION_PARSER_CLASS_NAME = "org.springframework.faces.webflow.FacesSpringELExpressionParser";
    private static final String WEBFLOW_SPRING_EL_EXPRESSION_PARSER_CLASS_NAME = "org.springframework.webflow.expression.spel.WebFlowSpringELExpressionParser";
    private static final String CONVERSION_SERVICE_ATTR = "conversion-service";
    private static final String DEVELOPMENT_ATTR = "development";
    private static final String ENABLE_MANAGED_BEANS_ATTR = "enable-managed-beans";
    private static final String EXPRESSION_PARSER_ATTR = "expression-parser";
    private static final String VIEW_FACTORY_CREATOR_ATTR = "view-factory-creator";
    private static final String CONVERSION_SERVICE_PROPERTY = "conversionService";
    private static final String DEVELOPMENT_PROPERTY = "development";
    private static final String EXPRESSION_PARSER_PROPERTY = "expressionParser";
    private static final String VIEW_FACTORY_CREATOR_PROPERTY = "viewFactoryCreator";

    protected String getBeanClassName(Element element) {
        return FLOW_BUILDER_SERVICES_CLASS_NAME;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder definitionBuilder) {
        CompositeComponentDefinition componentDefinition = new CompositeComponentDefinition(element.getLocalName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(componentDefinition);
        this.parseConversionService(element, parserContext, definitionBuilder);
        this.parseExpressionParser(element, parserContext, definitionBuilder, this.parseEnableManagedBeans(element, definitionBuilder));
        this.parseViewFactoryCreator(element, parserContext, definitionBuilder);
        this.parseDevelopment(element, definitionBuilder);
        parserContext.popAndRegisterContainingComponent();
    }

    private boolean parseEnableManagedBeans(Element element, BeanDefinitionBuilder definitionBuilder) {
        String enableManagedBeans = element.getAttribute(ENABLE_MANAGED_BEANS_ATTR);
        if (StringUtils.hasText((String)enableManagedBeans)) {
            return Boolean.valueOf(enableManagedBeans);
        }
        return false;
    }

    private void parseConversionService(Element element, ParserContext context, BeanDefinitionBuilder definitionBuilder) {
        String conversionService = element.getAttribute(CONVERSION_SERVICE_ATTR);
        if (!StringUtils.hasText((String)conversionService)) {
            BeanDefinitionBuilder conversionServiceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)FACES_CONVERSION_SERVICE_CLASS_NAME);
            conversionService = this.registerInfrastructureComponent(element, context, conversionServiceBuilder);
        }
        definitionBuilder.addPropertyReference(CONVERSION_SERVICE_PROPERTY, conversionService);
    }

    private void parseViewFactoryCreator(Element element, ParserContext context, BeanDefinitionBuilder definitionBuilder) {
        String viewFactoryCreator = element.getAttribute(VIEW_FACTORY_CREATOR_ATTR);
        if (!StringUtils.hasText((String)viewFactoryCreator)) {
            BeanDefinitionBuilder viewFactoryCreatorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)JSF_VIEW_FACTORY_CREATOR_CLASS_NAME);
            viewFactoryCreator = this.registerInfrastructureComponent(element, context, viewFactoryCreatorBuilder);
        }
        definitionBuilder.addPropertyReference(VIEW_FACTORY_CREATOR_PROPERTY, viewFactoryCreator);
    }

    private void parseExpressionParser(Element element, ParserContext context, BeanDefinitionBuilder definitionBuilder, boolean enableManagedBeans) {
        String expressionParser = element.getAttribute(EXPRESSION_PARSER_ATTR);
        if (!StringUtils.hasText((String)expressionParser)) {
            BeanDefinitionBuilder spelExpressionParser = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.expression.spel.standard.SpelExpressionParser");
            BeanDefinitionBuilder expressionParserBuilder = enableManagedBeans ? BeanDefinitionBuilder.genericBeanDefinition((String)FACES_SPRING_EL_EXPRESSION_PARSER_CLASS_NAME) : BeanDefinitionBuilder.genericBeanDefinition((String)WEBFLOW_SPRING_EL_EXPRESSION_PARSER_CLASS_NAME);
            expressionParserBuilder.addConstructorArgValue((Object)spelExpressionParser.getBeanDefinition());
            expressionParserBuilder.addConstructorArgReference(this.getConversionService(definitionBuilder));
            expressionParser = this.registerInfrastructureComponent(element, context, expressionParserBuilder);
        } else if (enableManagedBeans) {
            context.getReaderContext().error("Do not specify a custom expression-parser when enable-managed-beans is true", context.extractSource((Object)element));
        }
        definitionBuilder.addPropertyReference(EXPRESSION_PARSER_PROPERTY, expressionParser);
    }

    private void parseDevelopment(Element element, BeanDefinitionBuilder definitionBuilder) {
        String development = element.getAttribute("development");
        if (StringUtils.hasText((String)development)) {
            definitionBuilder.addPropertyValue("development", (Object)development);
        }
    }

    private String getConversionService(BeanDefinitionBuilder definitionBuilder) {
        RuntimeBeanReference conversionServiceReference = (RuntimeBeanReference)definitionBuilder.getBeanDefinition().getPropertyValues().getPropertyValue(CONVERSION_SERVICE_PROPERTY).getValue();
        return conversionServiceReference.getBeanName();
    }

    private String registerInfrastructureComponent(Element element, ParserContext context, BeanDefinitionBuilder componentBuilder) {
        String beanName = context.getReaderContext().generateBeanName((BeanDefinition)componentBuilder.getRawBeanDefinition());
        componentBuilder.getRawBeanDefinition().setSource(context.extractSource((Object)element));
        componentBuilder.getRawBeanDefinition().setRole(2);
        context.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)componentBuilder.getBeanDefinition(), beanName));
        return beanName;
    }
}

