/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.w3c.dom.Element;

public class ResourcesBeanDefinitionParser
implements BeanDefinitionParser {
    static final String RESOURCE_HANDLER_BEAN_NAME = "jsfResourceRequestHandler";
    static final String RESOURCE_HANDLER_CLASS_NAME = "org.springframework.faces.webflow.JsfResourceRequestHandler";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        this.registerHandlerAdapterIfNecessary(parserContext, source);
        this.registerResourceHandler(parserContext, source);
        this.registerHandlerMappings(element, parserContext, source);
        return null;
    }

    private void registerHandlerMappings(Element element, ParserContext parserContext, Object source) {
        ManagedMap urlMap = new ManagedMap();
        urlMap.put("/javax.faces.resource/**", RESOURCE_HANDLER_BEAN_NAME);
        RootBeanDefinition beanDefinition = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        beanDefinition.getPropertyValues().add("urlMap", (Object)urlMap);
        String order = element.getAttribute("order");
        beanDefinition.getPropertyValues().add("order", StringUtils.hasText((String)order) ? order : Integer.valueOf(0));
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanDefinition);
    }

    private void registerResourceHandler(ParserContext parserContext, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(RESOURCE_HANDLER_CLASS_NAME);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        parserContext.getRegistry().registerBeanDefinition(RESOURCE_HANDLER_BEAN_NAME, (BeanDefinition)beanDefinition);
    }

    private void registerHandlerAdapterIfNecessary(ParserContext parserContext, Object source) {
        if (parserContext.getRegistry().containsBeanDefinition("org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter")) {
            return;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(HttpRequestHandlerAdapter.class);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanDefinition);
    }
}

