/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.io.IOException;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.faces.webflow.JsfUtils;
import org.springframework.faces.webflow.ViewRootHolder;
import org.springframework.util.Assert;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class FlowViewHandler
extends ViewHandler {
    private ViewHandler delegate;

    public FlowViewHandler(ViewHandler delegate) {
        Assert.notNull((Object)delegate, (String)"The delegate ViewHandler instance must not be null!");
        this.delegate = delegate;
    }

    protected ViewHandler getDelegate() {
        return this.delegate;
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (JsfUtils.isFlowRequest()) {
            return RequestContextHolder.getRequestContext().getFlowExecutionUrl();
        }
        return this.delegate.getActionURL(context, viewId);
    }

    public Locale calculateLocale(FacesContext context) {
        if (JsfUtils.isFlowRequest()) {
            return RequestContextHolder.getRequestContext().getExternalContext().getLocale();
        }
        return this.delegate.calculateLocale(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        String resourcePath = viewId;
        if (JsfUtils.isFlowRequest()) {
            resourcePath = this.resolveResourcePath(RequestContextHolder.getRequestContext(), viewId);
        }
        return this.delegate.createView(context, resourcePath);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        String resourcePath = viewId;
        if (JsfUtils.isFlowRequest()) {
            resourcePath = this.resolveResourcePath(RequestContextHolder.getRequestContext(), viewId);
            return this.restoreFlowView(context, resourcePath);
        }
        return this.delegate.restoreView(context, resourcePath);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.delegate.calculateRenderKitId(context);
    }

    public String getResourceURL(FacesContext context, String path) {
        return this.delegate.getResourceURL(context, path);
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        this.delegate.renderView(context, viewToRender);
    }

    public void writeState(FacesContext context) throws IOException {
        this.delegate.writeState(context);
    }

    public String deriveViewId(FacesContext context, String rawViewId) {
        if (JsfUtils.isFlowRequest()) {
            return this.resolveResourcePath(RequestContextHolder.getRequestContext(), rawViewId);
        }
        return this.getDelegate().deriveViewId(context, rawViewId);
    }

    private String resolveResourcePath(RequestContext context, String viewId) {
        if (viewId.startsWith("/")) {
            return viewId;
        }
        ApplicationContext flowContext = context.getActiveFlow().getApplicationContext();
        if (flowContext == null) {
            throw new IllegalStateException("A Flow ApplicationContext is required to resolve Flow View Resources");
        }
        Resource viewResource = flowContext.getResource(viewId);
        if (!(viewResource instanceof ContextResource)) {
            throw new IllegalStateException("A ContextResource is required to get relative view paths within this context; the resource was " + viewResource);
        }
        String viewPath = ((ContextResource)viewResource).getPathWithinContext();
        if (!viewPath.startsWith("/")) {
            viewPath = "/" + viewPath;
        }
        return viewPath;
    }

    private UIViewRoot restoreFlowView(FacesContext facesContext, String resourcePath) {
        RequestContext context = RequestContextHolder.getRequestContext();
        ViewRootHolder holder = (ViewRootHolder)context.getFlashScope().get("viewUserEventState");
        if (holder != null && holder.getViewRoot() != null && holder.getViewRoot().getViewId().equals(resourcePath)) {
            return holder.getViewRoot();
        }
        return this.delegate.restoreView(facesContext, resourcePath);
    }
}

