/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow.context.portlet;

import com.sun.faces.context.flash.ELFlash;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.Flash;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.ClientDataRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceResponse;
import javax.servlet.http.Cookie;
import org.apache.myfaces.shared.context.flash.FlashImpl;
import org.springframework.binding.collection.MapAdaptable;
import org.springframework.faces.webflow.JsfRuntimeInformation;
import org.springframework.faces.webflow.context.portlet.InitParameterMap;
import org.springframework.faces.webflow.context.portlet.MultiValueRequestParameterMap;
import org.springframework.faces.webflow.context.portlet.MultiValueRequestPropertyMap;
import org.springframework.faces.webflow.context.portlet.PortletResponseUtils;
import org.springframework.faces.webflow.context.portlet.SingleValueRequestParameterMap;
import org.springframework.faces.webflow.context.portlet.SingleValueRequestPropertyMap;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.webflow.context.portlet.PortletContextMap;
import org.springframework.webflow.context.portlet.PortletRequestMap;
import org.springframework.webflow.context.portlet.PortletSessionMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.core.collection.LocalAttributeMap;

public class PortletExternalContextImpl
extends ExternalContext {
    private Map<String, Object> applicationMap;
    private PortletContext portletContext;
    private PortletRequest request;
    private PortletResponse response;
    private boolean isActionRequest;
    private Map<String, String> initParameterMap;
    private Map<String, String> requestHeaderMap;
    private Map<String, String[]> requestHeaderValuesMap;
    private Map<String, Object> requestMap;
    private Map<String, String> requestParameterMap;
    private Map<String, String[]> requestParameterValuesMap;
    private MapAdaptable<String, Object> sessionMap;
    private Flash flash;

    public PortletExternalContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this.portletContext = portletContext;
        this.request = portletRequest;
        this.response = portletResponse;
        if (portletRequest instanceof ActionRequest) {
            this.isActionRequest = true;
        }
    }

    public void release() {
        this.portletContext = null;
        this.request = null;
        this.response = null;
        this.applicationMap = null;
        this.sessionMap = null;
        this.requestMap = null;
        this.requestParameterMap = null;
        this.requestParameterValuesMap = null;
        this.requestHeaderMap = null;
        this.requestHeaderValuesMap = null;
        this.initParameterMap = null;
    }

    public Flash getFlash() {
        if (this.flash == null) {
            this.flash = this.createFlash();
        }
        return this.flash;
    }

    private Flash createFlash() {
        if (JsfRuntimeInformation.isMyFacesPresent()) {
            return new MyFacesFlashFactory().newFlash(this);
        }
        return new MojarraFlashFactory().newFlash(this);
    }

    public void dispatch(String path) throws IOException {
        Assert.isTrue((!this.isActionRequest ? 1 : 0) != 0);
        PortletRequestDispatcher requestDispatcher = this.portletContext.getRequestDispatcher(path);
        try {
            requestDispatcher.include((RenderRequest)this.request, (RenderResponse)this.response);
        }
        catch (PortletException exception) {
            if (exception.getMessage() != null) {
                throw new FacesException(exception.getMessage(), (Throwable)exception);
            }
            throw new FacesException((Throwable)exception);
        }
    }

    public void redirect(String url) throws IOException {
        Assert.isInstanceOf(ActionResponse.class, (Object)this.response);
        ((ActionResponse)this.response).sendRedirect(url);
    }

    public String encodeNamespace(String name) {
        Assert.isTrue((!this.isActionRequest ? 1 : 0) != 0);
        return name + ((RenderResponse)this.response).getNamespace();
    }

    public String encodeActionURL(String url) {
        Assert.notNull((Object)url);
        return this.response.encodeURL(url);
    }

    public String encodeResourceURL(String url) {
        Assert.notNull((Object)url);
        return this.response.encodeURL(url);
    }

    public String encodePartialActionURL(String url) {
        Assert.notNull((Object)url);
        return this.response.encodeURL(url);
    }

    public String encodeBookmarkableURL(String baseUrl, Map<String, List<String>> parameters) {
        return this.encodeUrl(baseUrl, parameters);
    }

    public String encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        return this.response.encodeURL(this.encodeUrl(baseUrl, parameters));
    }

    private String encodeUrl(String baseUrl, Map<String, List<String>> parameters) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)baseUrl);
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            builder.queryParam(entry.getKey(), entry.getValue().toArray());
        }
        return builder.buildAndExpand(new Object[0]).toUriString();
    }

    public Object getContext() {
        return this.portletContext;
    }

    public String getContextName() {
        return this.portletContext.getPortletContextName();
    }

    public String getMimeType(String file) {
        return this.portletContext.getMimeType(file);
    }

    public String getRealPath(String path) {
        return this.portletContext.getRealPath(path);
    }

    public void log(String message) {
        Assert.notNull((Object)message);
        this.portletContext.log(message);
    }

    public void log(String message, Throwable exception) {
        Assert.notNull((Object)message);
        Assert.notNull((Object)exception);
        this.portletContext.log(message, exception);
    }

    public Map<String, Object> getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new PortletContextMap(this.portletContext);
        }
        return this.applicationMap;
    }

    public String getInitParameter(String name) {
        return this.portletContext.getInitParameter(name);
    }

    public Map<String, String> getInitParameterMap() {
        if (this.initParameterMap == null) {
            this.initParameterMap = new InitParameterMap(this.portletContext);
        }
        return this.initParameterMap;
    }

    public URL getResource(String path) throws MalformedURLException {
        Assert.notNull((Object)path);
        return this.portletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        Assert.notNull((Object)path);
        return this.portletContext.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        Assert.notNull((Object)path);
        return this.portletContext.getResourcePaths(path);
    }

    public Object getRequest() {
        return this.request;
    }

    public void setRequest(Object request) {
        this.request = (PortletRequest)request;
    }

    public String getRequestContentType() {
        if (this.request instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.request;
            return clientDataRequest.getContentType();
        }
        return null;
    }

    public String getRequestContextPath() {
        return this.request.getContextPath();
    }

    public String getRequestScheme() {
        return this.request.getScheme();
    }

    public String getRequestServerName() {
        return this.request.getServerName();
    }

    public int getRequestServerPort() {
        return this.request.getServerPort();
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public Iterator<Locale> getRequestLocales() {
        return CollectionUtils.toIterator((Enumeration)this.request.getLocales());
    }

    public String getRequestCharacterEncoding() {
        if (this.request instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.request).getCharacterEncoding();
        }
        Assert.state((boolean)(this.response instanceof MimeResponse));
        return ((MimeResponse)this.response).getCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        Assert.isInstanceOf(ClientDataRequest.class, (Object)this.request);
        ((ClientDataRequest)this.request).setCharacterEncoding(encoding);
    }

    public Map<String, Object> getRequestCookieMap() {
        return Collections.emptyMap();
    }

    public Map<String, String> getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.requestHeaderMap = new SingleValueRequestPropertyMap(this.request);
        }
        return this.requestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this.requestHeaderValuesMap == null) {
            this.requestHeaderValuesMap = new MultiValueRequestPropertyMap(this.request);
        }
        return this.requestHeaderValuesMap;
    }

    public Map<String, Object> getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new PortletRequestMap(this.request);
        }
        return this.requestMap;
    }

    public Map<String, String> getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = new SingleValueRequestParameterMap(this.request);
        }
        return this.requestParameterMap;
    }

    public Iterator<String> getRequestParameterNames() {
        return CollectionUtils.toIterator((Enumeration)this.request.getParameterNames());
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap == null) {
            this.requestParameterValuesMap = new MultiValueRequestParameterMap(this.request);
        }
        return this.requestParameterValuesMap;
    }

    public String getRequestServletPath() {
        return "";
    }

    public String getRequestPathInfo() {
        return "";
    }

    public int getRequestContentLength() {
        Assert.isInstanceOf(ClientDataRequest.class, (Object)this.request);
        return ((ClientDataRequest)this.request).getContentLength();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        Assert.notNull((Object)role);
        return this.request.isUserInRole(role);
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public Object getResponse() {
        return this.response;
    }

    public void setResponse(Object response) {
        this.response = (PortletResponse)response;
    }

    public String getResponseContentType() {
        return this.getMimeResponse().getContentType();
    }

    public String getResponseCharacterEncoding() {
        return this.getMimeResponse().getCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
    }

    public OutputStream getResponseOutputStream() throws IOException {
        return this.getMimeResponse().getPortletOutputStream();
    }

    public Writer getResponseOutputWriter() throws IOException {
        return this.getMimeResponse().getWriter();
    }

    public void addResponseCookie(String name, String value, Map<String, Object> properties) {
        Cookie cookie = new Cookie(name, value);
        this.setCookieProperties(cookie, properties);
        this.response.addProperty(cookie);
    }

    private void setCookieProperties(Cookie cookie, Map<String, Object> properties) {
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                this.setCookieProperty(cookie, entry.getKey(), entry.getValue());
            }
        }
    }

    private void setCookieProperty(Cookie cookie, String property, Object value) {
        if ("domain".equalsIgnoreCase(property)) {
            cookie.setDomain((String)value);
            return;
        }
        if ("maxAge".equalsIgnoreCase(property)) {
            cookie.setMaxAge(((Integer)value).intValue());
            return;
        }
        if ("path".equalsIgnoreCase(property)) {
            cookie.setPath((String)value);
            return;
        }
        if ("secure".equalsIgnoreCase(property)) {
            cookie.setSecure(((Boolean)value).booleanValue());
            return;
        }
        throw new IllegalStateException("Unknown cookie property " + property);
    }

    public void addResponseHeader(String name, String value) {
        this.response.addProperty(name, value);
    }

    public void responseFlushBuffer() throws IOException {
        this.getMimeResponse().flushBuffer();
    }

    public void responseReset() {
        MimeResponse mimeResponse = this.getMimeResponse(false);
        if (mimeResponse != null) {
            mimeResponse.reset();
        }
    }

    public void responseSendError(int statusCode, String message) throws IOException {
        throw new IOException(statusCode + ": " + message);
    }

    public void setResponseBufferSize(int size) {
        this.getMimeResponse().setBufferSize(size);
    }

    public void setResponseContentLength(int length) {
        if (this.portletContext instanceof ResourceResponse) {
            ((ResourceResponse)this.portletContext).setContentLength(length);
        }
    }

    public void setResponseContentType(String contentType) {
        MimeResponse mimeResponse = this.getMimeResponse(false);
        if (mimeResponse != null) {
            mimeResponse.setContentType(contentType);
        }
    }

    public void setResponseHeader(String name, String value) {
        this.response.setProperty(name, value);
    }

    public void setResponseStatus(int statusCode) {
        this.response.setProperty("portlet.http-status-code", String.valueOf(statusCode));
        PortletResponseUtils.setStatusCodeForPluto(this.response, statusCode);
    }

    public boolean isResponseCommitted() {
        MimeResponse mimeResponse = this.getMimeResponse(false);
        return mimeResponse != null ? mimeResponse.isCommitted() : false;
    }

    public int getResponseBufferSize() {
        return this.getMimeResponse().getBufferSize();
    }

    private MimeResponse getMimeResponse() {
        return this.getMimeResponse(true);
    }

    private MimeResponse getMimeResponse(boolean required) {
        if (this.response instanceof MimeResponse) {
            return (MimeResponse)this.response;
        }
        if (!required) {
            return null;
        }
        throw new IllegalStateException("Portlet response is not a MimeResponse");
    }

    public Object getSession(boolean create) {
        return this.request.getPortletSession(create);
    }

    public Map<String, Object> getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new LocalAttributeMap((Map)new PortletSessionMap(this.request));
        }
        return this.sessionMap.asMap();
    }

    public int getSessionMaxInactiveInterval() {
        return this.request.getPortletSession().getMaxInactiveInterval();
    }

    public void invalidateSession() {
        PortletSession portletSession = this.request.getPortletSession(false);
        if (portletSession != null) {
            portletSession.invalidate();
        }
    }

    public void setSessionMaxInactiveInterval(int interval) {
        this.request.getPortletSession().setMaxInactiveInterval(interval);
    }

    private static class MyFacesFlashFactory {
        private MyFacesFlashFactory() {
        }

        public Flash newFlash(ExternalContext context) {
            return FlashImpl.getCurrentInstance((ExternalContext)context);
        }
    }

    private static class MojarraFlashFactory {
        private MojarraFlashFactory() {
        }

        public Flash newFlash(ExternalContext context) {
            return (Flash)ELFlash.getFlash();
        }
    }
}

