/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.portlet.DefaultFlowUrlHandler;
import org.springframework.webflow.context.portlet.FlowUrlHandler;
import org.springframework.webflow.context.portlet.PortletContextMap;
import org.springframework.webflow.context.portlet.PortletRequestMap;
import org.springframework.webflow.context.portlet.PortletRequestParameterMap;
import org.springframework.webflow.context.portlet.PortletSessionMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalParameterMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;

public class PortletExternalContext
implements ExternalContext {
    protected static final short ACTION_PHASE = 1;
    protected static final short RENDER_PHASE = 2;
    private PortletContext context;
    private PortletRequest request;
    private PortletResponse response;
    private short requestPhase;
    private ParameterMap requestParameterMap;
    private MutableAttributeMap requestMap;
    private SharedAttributeMap sessionMap;
    private SharedAttributeMap applicationMap;
    private boolean responseComplete;
    private boolean flowExecutionRedirectRequested;
    private String flowDefinitionRedirectFlowId;
    private MutableAttributeMap flowDefinitionRedirectFlowInput;
    private String externalRedirectUrl;
    private FlowUrlHandler flowUrlHandler;
    private boolean redirectInPopup;

    public PortletExternalContext(PortletContext context, PortletRequest request, PortletResponse response) {
        this.init(context, request, response, new DefaultFlowUrlHandler());
    }

    public PortletExternalContext(PortletContext context, PortletRequest request, PortletResponse response, FlowUrlHandler flowUrlHandler) {
        this.init(context, request, response, flowUrlHandler);
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public ParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public MutableAttributeMap getRequestMap() {
        return this.requestMap;
    }

    public SharedAttributeMap getSessionMap() {
        return this.sessionMap;
    }

    public SharedAttributeMap getGlobalSessionMap() {
        return this.getSessionMap();
    }

    public SharedAttributeMap getApplicationMap() {
        return this.applicationMap;
    }

    public Principal getCurrentUser() {
        return this.request.getUserPrincipal();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Object getNativeContext() {
        return this.context;
    }

    public Object getNativeRequest() {
        return this.request;
    }

    public Object getNativeResponse() {
        return this.response;
    }

    public boolean isAjaxRequest() {
        return false;
    }

    public String getFlowExecutionUrl(String flowId, String flowExecutionKey) {
        if (!this.isRenderPhase()) {
            throw new IllegalStateException("A flow execution action URL can only be obtained in a RenderRequest using a RenderResponse");
        }
        return this.flowUrlHandler.createFlowExecutionUrl(flowId, flowExecutionKey, (RenderResponse)this.response);
    }

    public Writer getResponseWriter() throws IllegalStateException {
        this.assertResponseAllowed();
        try {
            return ((RenderResponse)this.response).getWriter();
        }
        catch (IOException e) {
            IllegalStateException ise = new IllegalStateException("Unable to access the response Writer");
            ise.initCause(e);
            throw ise;
        }
    }

    public boolean isResponseAllowed() {
        return this.isRenderPhase() && !this.responseComplete;
    }

    public boolean isResponseComplete() {
        return this.responseComplete;
    }

    public void recordResponseComplete() {
        this.responseComplete = true;
    }

    public boolean isResponseCompleteFlowExecutionRedirect() {
        return this.flowExecutionRedirectRequested;
    }

    public void requestFlowExecutionRedirect() throws IllegalStateException {
        this.assertRedirectResponseAllowed();
        this.flowExecutionRedirectRequested = true;
        this.recordResponseComplete();
    }

    public void requestFlowDefinitionRedirect(String flowId, MutableAttributeMap input) throws IllegalStateException {
        this.assertRedirectResponseAllowed();
        this.flowDefinitionRedirectFlowId = flowId;
        this.flowDefinitionRedirectFlowInput = input != null ? input : new LocalAttributeMap();
        this.recordResponseComplete();
    }

    public void requestExternalRedirect(String uri) throws IllegalStateException {
        this.assertRedirectResponseAllowed();
        this.externalRedirectUrl = uri;
        this.recordResponseComplete();
    }

    public void requestRedirectInPopup() throws IllegalStateException {
        if (!this.isRedirectRequested()) {
            throw new IllegalStateException("Only call requestRedirectInPopup after a redirect has been requested by calling requestFlowExecutionRedirect, requestFlowDefinitionRedirect, or requestExternalRedirect");
        }
        this.redirectInPopup = true;
    }

    public boolean getFlowExecutionRedirectRequested() {
        return this.flowExecutionRedirectRequested;
    }

    public boolean getFlowDefinitionRedirectRequested() {
        return this.flowDefinitionRedirectFlowId != null;
    }

    public String getFlowRedirectFlowId() {
        return this.flowDefinitionRedirectFlowId;
    }

    public MutableAttributeMap getFlowRedirectFlowInput() {
        return this.flowDefinitionRedirectFlowInput;
    }

    public boolean getExternalRedirectRequested() {
        return this.externalRedirectUrl != null;
    }

    public String getExternalRedirectUrl() {
        return this.externalRedirectUrl;
    }

    public boolean getRedirectInPopup() {
        return this.redirectInPopup;
    }

    public boolean isActionPhase() {
        return this.requestPhase == 1;
    }

    public boolean isRenderPhase() {
        return this.requestPhase == 2;
    }

    private void init(PortletContext context, PortletRequest request, PortletResponse response, FlowUrlHandler flowUrlHandler) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.requestParameterMap = new LocalParameterMap((Map)((Object)new PortletRequestParameterMap(request)));
        this.requestMap = new LocalAttributeMap((Map)((Object)new PortletRequestMap(request)));
        this.sessionMap = new LocalSharedAttributeMap(new PortletSessionMap(request));
        this.applicationMap = new LocalSharedAttributeMap(new PortletContextMap(context));
        this.flowUrlHandler = flowUrlHandler;
        if (request instanceof ActionRequest && response instanceof ActionResponse) {
            this.requestPhase = 1;
        } else if (request instanceof RenderRequest && response instanceof RenderResponse) {
            this.requestPhase = (short)2;
        } else {
            throw new IllegalArgumentException("Unknown portlet phase, expected: action or render");
        }
    }

    private void assertResponseAllowed() throws IllegalStateException {
        if (!this.isRenderPhase()) {
            throw new IllegalStateException("A response is not allowed because the current PortletRequest is not a RenderRequest");
        }
        if (this.responseComplete) {
            throw new IllegalStateException("A response is not allowed because recordResponseComplete() has already been called on this ExternalContext");
        }
    }

    private void assertRedirectResponseAllowed() throws IllegalStateException {
        if (!this.isActionPhase()) {
            throw new IllegalStateException("A redirect is not allowed because the current PortletRequest is not a ActionRequest");
        }
        if (this.responseComplete) {
            throw new IllegalStateException("A redirect is not allowed because a response has already been completed on this ExternalContext");
        }
    }

    private boolean isRedirectRequested() {
        return this.getFlowExecutionRedirectRequested() || this.getFlowDefinitionRedirectRequested() || this.getExternalRedirectRequested();
    }
}

