/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class FlowBuilderServicesBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String WEB_FLOW_SPRING_EL_EXPRESSION_PARSER_CLASS_NAME = "org.springframework.webflow.expression.spel.WebFlowSpringELExpressionParser";
    private static final String SPRING_EL_EXPRESSION_PARSER_CLASS_NAME = "org.springframework.expression.spel.standard.SpelExpressionParser";
    private static final String DEFAULT_CONVERSION_SERVICE_CLASS_NAME = "org.springframework.binding.convert.service.DefaultConversionService";
    private static final String FLOW_BUILDER_SERVICES_CLASS_NAME = "org.springframework.webflow.engine.builder.support.FlowBuilderServices";
    private static final String MVC_VIEW_FACTORY_CREATOR_CLASS_NAME = "org.springframework.webflow.mvc.builder.MvcViewFactoryCreator";
    private static final String CONVERSION_SERVICE_ATTR = "conversion-service";
    private static final String DEVELOPMENT_ATTR = "development";
    private static final String EXPRESSION_PARSER_ATTR = "expression-parser";
    private static final String VIEW_FACTORY_CREATOR_ATTR = "view-factory-creator";
    private static final String CONVERSION_SERVICE_PROPERTY = "conversionService";
    private static final String DEVELOPMENT_PROPERTY = "development";
    private static final String EXPRESSION_PARSER_PROPERTY = "expressionParser";
    private static final String VIEW_FACTORY_CREATOR_PROPERTY = "viewFactoryCreator";

    FlowBuilderServicesBeanDefinitionParser() {
    }

    protected String getBeanClassName(Element element) {
        return FLOW_BUILDER_SERVICES_CLASS_NAME;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        CompositeComponentDefinition componentDefinition = new CompositeComponentDefinition(element.getLocalName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(componentDefinition);
        this.parseConversionService(element, parserContext, builder);
        this.parseExpressionParser(element, parserContext, builder);
        this.parseViewFactoryCreator(element, parserContext, builder);
        this.parseDevelopment(element, builder);
        parserContext.popAndRegisterContainingComponent();
    }

    private void parseConversionService(Element element, ParserContext context, BeanDefinitionBuilder definitionBuilder) {
        String conversionService = element.getAttribute(CONVERSION_SERVICE_ATTR);
        if (!StringUtils.hasText((String)conversionService)) {
            BeanDefinitionBuilder conversionServiceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)DEFAULT_CONVERSION_SERVICE_CLASS_NAME);
            conversionService = this.registerInfrastructureComponent(element, context, conversionServiceBuilder);
        }
        definitionBuilder.addPropertyReference(CONVERSION_SERVICE_PROPERTY, conversionService);
    }

    private void parseExpressionParser(Element element, ParserContext context, BeanDefinitionBuilder definitionBuilder) {
        String expressionParser = element.getAttribute(EXPRESSION_PARSER_ATTR);
        if (!StringUtils.hasText((String)expressionParser)) {
            BeanDefinitionBuilder springElExpressionParserBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)SPRING_EL_EXPRESSION_PARSER_CLASS_NAME);
            BeanDefinitionBuilder webFlowElExpressionParserBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)WEB_FLOW_SPRING_EL_EXPRESSION_PARSER_CLASS_NAME);
            webFlowElExpressionParserBuilder.addConstructorArgValue((Object)springElExpressionParserBuilder.getBeanDefinition());
            webFlowElExpressionParserBuilder.addConstructorArgReference(this.getConversionService(definitionBuilder));
            expressionParser = this.registerInfrastructureComponent(element, context, webFlowElExpressionParserBuilder);
        }
        definitionBuilder.addPropertyReference(EXPRESSION_PARSER_PROPERTY, expressionParser);
    }

    private void parseViewFactoryCreator(Element element, ParserContext context, BeanDefinitionBuilder definitionBuilder) {
        String viewFactoryCreator = element.getAttribute(VIEW_FACTORY_CREATOR_ATTR);
        if (!StringUtils.hasText((String)viewFactoryCreator)) {
            BeanDefinitionBuilder viewFactoryCreatorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)MVC_VIEW_FACTORY_CREATOR_CLASS_NAME);
            viewFactoryCreator = this.registerInfrastructureComponent(element, context, viewFactoryCreatorBuilder);
        }
        definitionBuilder.addPropertyReference(VIEW_FACTORY_CREATOR_PROPERTY, viewFactoryCreator);
    }

    private void parseDevelopment(Element element, BeanDefinitionBuilder definitionBuilder) {
        String development = element.getAttribute("development");
        if (StringUtils.hasText((String)development)) {
            definitionBuilder.addPropertyValue("development", (Object)development);
        }
    }

    private String getConversionService(BeanDefinitionBuilder definitionBuilder) {
        RuntimeBeanReference conversionServiceReference = (RuntimeBeanReference)definitionBuilder.getBeanDefinition().getPropertyValues().getPropertyValue(CONVERSION_SERVICE_PROPERTY).getValue();
        return conversionServiceReference.getBeanName();
    }

    private String registerInfrastructureComponent(Element element, ParserContext context, BeanDefinitionBuilder componentBuilder) {
        String beanName = context.getReaderContext().generateBeanName((BeanDefinition)componentBuilder.getRawBeanDefinition());
        componentBuilder.getRawBeanDefinition().setSource(context.extractSource((Object)element));
        componentBuilder.getRawBeanDefinition().setRole(2);
        context.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)componentBuilder.getBeanDefinition(), beanName));
        return beanName;
    }
}

