/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.support;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.FlowBuilderContext;
import org.springframework.webflow.engine.builder.FlowBuilderException;

public abstract class AbstractFlowBuilder
implements FlowBuilder {
    private Flow flow;
    private FlowBuilderContext context;

    public void init(FlowBuilderContext context) throws FlowBuilderException {
        this.context = context;
        this.doInit();
        this.flow = this.createFlow();
    }

    protected void doInit() {
    }

    protected Flow createFlow() {
        String id = this.getContext().getFlowId();
        AttributeMap attributes = this.getContext().getFlowAttributes();
        return this.getContext().getFlowArtifactFactory().createFlow(id, attributes);
    }

    protected FlowBuilderContext getContext() {
        return this.context;
    }

    public void buildVariables() throws FlowBuilderException {
    }

    public void buildInputMapper() throws FlowBuilderException {
    }

    public void buildStartActions() throws FlowBuilderException {
    }

    public abstract void buildStates() throws FlowBuilderException;

    public void buildGlobalTransitions() throws FlowBuilderException {
    }

    public void buildEndActions() throws FlowBuilderException {
    }

    public void buildOutputMapper() throws FlowBuilderException {
    }

    public void buildExceptionHandlers() throws FlowBuilderException {
    }

    public Flow getFlow() throws FlowBuilderException {
        return this.flow;
    }

    public void dispose() throws FlowBuilderException {
        this.flow = null;
        this.doDispose();
    }

    public boolean hasFlowChanged() {
        return false;
    }

    public String getFlowResourceString() {
        return this.getClass().getName();
    }

    protected void doDispose() {
    }
}

