/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.conversation.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationId;
import org.springframework.webflow.conversation.ConversationParameters;
import org.springframework.webflow.conversation.NoSuchConversationException;
import org.springframework.webflow.conversation.impl.ContainedConversation;
import org.springframework.webflow.conversation.impl.ConversationLockFactory;
import org.springframework.webflow.conversation.impl.SimpleConversationId;

class ConversationContainer
implements Serializable {
    private static final Log logger = LogFactory.getLog(ConversationContainer.class);
    private int maxConversations;
    private String sessionKey;
    private List conversations;
    private int conversationIdSequence;

    public ConversationContainer(int maxConversations, String sessionKey) {
        this.maxConversations = maxConversations;
        this.sessionKey = sessionKey;
        this.conversations = new ArrayList();
    }

    String getSessionKey() {
        return this.sessionKey;
    }

    public int size() {
        return this.conversations.size();
    }

    public synchronized Conversation createConversation(ConversationParameters parameters, ConversationLockFactory lockFactory) {
        ContainedConversation conversation = new ContainedConversation(this, this.nextId(), lockFactory.createLock());
        conversation.putAttribute("name", parameters.getName());
        conversation.putAttribute("caption", parameters.getCaption());
        conversation.putAttribute("description", parameters.getDescription());
        this.conversations.add(conversation);
        if (this.maxExceeded()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The maximum number of flow executions has been exceeded for the current user. Removing the oldest conversation with id: " + ((Conversation)this.conversations.get(0)).getId()));
            }
            ((Conversation)this.conversations.get(0)).end();
        }
        return conversation;
    }

    private ConversationId nextId() {
        return new SimpleConversationId(Integer.valueOf(++this.conversationIdSequence));
    }

    public synchronized Conversation getConversation(ConversationId id) throws NoSuchConversationException {
        for (ContainedConversation conversation : this.conversations) {
            if (!conversation.getId().equals(id)) continue;
            return conversation;
        }
        throw new NoSuchConversationException(id);
    }

    public synchronized void removeConversation(ConversationId id) {
        Iterator it = this.conversations.iterator();
        while (it.hasNext()) {
            ContainedConversation conversation = (ContainedConversation)it.next();
            if (!conversation.getId().equals(id)) continue;
            it.remove();
            break;
        }
    }

    private boolean maxExceeded() {
        return this.maxConversations > 0 && this.conversations.size() > this.maxConversations;
    }
}

