/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.el;

import javax.el.ELContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.el.SpringBeanELResolver;
import org.springframework.beans.factory.support.StaticListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class SpringBeanWebFlowELResolver
extends SpringBeanELResolver {
    private static final BeanFactory EMPTY_BEAN_FACTORY = new StaticListableBeanFactory();
    private RequestContext requestContext;

    public SpringBeanWebFlowELResolver() {
    }

    public SpringBeanWebFlowELResolver(RequestContext context) {
        this.requestContext = context;
    }

    protected BeanFactory getBeanFactory(ELContext elContext) {
        RequestContext requestContext = this.getRequestContext();
        if (requestContext == null) {
            return EMPTY_BEAN_FACTORY;
        }
        ApplicationContext beanFactory = requestContext.getActiveFlow().getApplicationContext();
        return beanFactory != null ? beanFactory : EMPTY_BEAN_FACTORY;
    }

    protected RequestContext getRequestContext() {
        return this.requestContext != null ? this.requestContext : RequestContextHolder.getRequestContext();
    }
}

