/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback;

import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import com.sun.xml.wss.impl.callback.TimestampValidationCallback;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.xwss.callback.AbstractCallbackHandler;
import org.springframework.ws.soap.security.xwss.callback.DefaultTimestampValidator;

public class SimplePasswordValidationCallbackHandler
extends AbstractCallbackHandler
implements InitializingBean {
    private Properties users = new Properties();

    public void setUsers(Properties users) {
        this.users = users;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.users, (String)"users is required");
    }

    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (callback instanceof PasswordValidationCallback) {
            PasswordValidationCallback passwordCallback = (PasswordValidationCallback)callback;
            if (passwordCallback.getRequest() instanceof PasswordValidationCallback.PlainTextPasswordRequest) {
                passwordCallback.setValidator((PasswordValidationCallback.PasswordValidator)new SimplePlainTextPasswordValidator());
            } else if (passwordCallback.getRequest() instanceof PasswordValidationCallback.DigestPasswordRequest) {
                PasswordValidationCallback.DigestPasswordRequest digestPasswordRequest = (PasswordValidationCallback.DigestPasswordRequest)passwordCallback.getRequest();
                String password = this.users.getProperty(digestPasswordRequest.getUsername());
                digestPasswordRequest.setPassword(password);
                passwordCallback.setValidator((PasswordValidationCallback.PasswordValidator)new PasswordValidationCallback.DigestPasswordValidator());
            }
        } else if (callback instanceof TimestampValidationCallback) {
            TimestampValidationCallback timestampCallback = (TimestampValidationCallback)callback;
            timestampCallback.setValidator((TimestampValidationCallback.TimestampValidator)new DefaultTimestampValidator());
        } else {
            throw new UnsupportedCallbackException(callback);
        }
    }

    public void setUsersMap(Map users) {
        Iterator iterator = users.keySet().iterator();
        while (iterator.hasNext()) {
            String username = (String)iterator.next();
            String password = (String)users.get(username);
            this.users.setProperty(username, password);
        }
    }

    private class SimplePlainTextPasswordValidator
    implements PasswordValidationCallback.PasswordValidator {
        private SimplePlainTextPasswordValidator() {
        }

        public boolean validate(PasswordValidationCallback.Request request) throws PasswordValidationCallback.PasswordValidationException {
            PasswordValidationCallback.PlainTextPasswordRequest plainTextPasswordRequest = (PasswordValidationCallback.PlainTextPasswordRequest)request;
            String password = SimplePasswordValidationCallbackHandler.this.users.getProperty(plainTextPasswordRequest.getUsername());
            return password != null && password.equals(plainTextPasswordRequest.getPassword());
        }
    }
}

