/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback.acegi;

import com.sun.xml.wss.impl.callback.CertificateValidationCallback;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.x509.X509AuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.xwss.callback.AbstractCallbackHandler;

public class AcegiCertificateValidationCallbackHandler
extends AbstractCallbackHandler {
    private AuthenticationManager authenticationManager;
    private boolean ignoreFailure = false;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager is required");
    }

    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        if (!(callback instanceof CertificateValidationCallback)) {
            throw new UnsupportedCallbackException(callback);
        }
        ((CertificateValidationCallback)callback).setValidator((CertificateValidationCallback.CertificateValidator)new AcegiCertificateValidator());
    }

    private class AcegiCertificateValidator
    implements CertificateValidationCallback.CertificateValidator {
        private AcegiCertificateValidator() {
        }

        public boolean validate(X509Certificate certificate) throws CertificateValidationCallback.CertificateValidationException {
            try {
                Authentication authResult = AcegiCertificateValidationCallbackHandler.this.authenticationManager.authenticate((Authentication)new X509AuthenticationToken(certificate));
                if (AcegiCertificateValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    AcegiCertificateValidationCallbackHandler.this.logger.debug((Object)("Authentication request for certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] successful"));
                }
                SecurityContextHolder.getContext().setAuthentication(authResult);
                return true;
            }
            catch (AuthenticationException failed) {
                if (AcegiCertificateValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    AcegiCertificateValidationCallbackHandler.this.logger.debug((Object)("Authentication request for certificate with DN [" + certificate.getSubjectX500Principal().getName() + "] failed: " + failed.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication(null);
                boolean result = AcegiCertificateValidationCallbackHandler.this.ignoreFailure;
                return result;
            }
        }
    }
}

