/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.xwss.callback.jaas;

import com.sun.xml.wss.impl.callback.PasswordValidationCallback;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.springframework.ws.soap.security.xwss.callback.AbstractCallbackHandler;
import org.springframework.ws.soap.security.xwss.callback.jaas.AbstractJaasValidationCallbackHandler;

public class JaasPlainTextPasswordValidationCallbackHandler
extends AbstractJaasValidationCallbackHandler {
    protected JaasPlainTextPasswordValidationCallbackHandler() {
    }

    protected final void handleInternal(Callback callback) throws UnsupportedCallbackException {
        PasswordValidationCallback validationCallback;
        if (callback instanceof PasswordValidationCallback && (validationCallback = (PasswordValidationCallback)callback).getRequest() instanceof PasswordValidationCallback.PlainTextPasswordRequest) {
            validationCallback.setValidator((PasswordValidationCallback.PasswordValidator)new JaasPlainTextPasswordValidator());
            return;
        }
        throw new UnsupportedCallbackException(callback);
    }

    private class JaasPlainTextPasswordValidator
    implements PasswordValidationCallback.PasswordValidator {
        private JaasPlainTextPasswordValidator() {
        }

        public boolean validate(PasswordValidationCallback.Request request) throws PasswordValidationCallback.PasswordValidationException {
            PasswordValidationCallback.PlainTextPasswordRequest plainTextRequest = (PasswordValidationCallback.PlainTextPasswordRequest)request;
            final String username = plainTextRequest.getUsername();
            final String password = plainTextRequest.getPassword();
            LoginContext loginContext = null;
            try {
                loginContext = new LoginContext(JaasPlainTextPasswordValidationCallbackHandler.this.getLoginContextName(), new AbstractCallbackHandler(){

                    protected void handleInternal(Callback callback) throws UnsupportedCallbackException {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(username);
                        } else if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(password.toCharArray());
                        } else {
                            throw new UnsupportedCallbackException(callback);
                        }
                    }
                });
            }
            catch (LoginException ex) {
                throw new PasswordValidationCallback.PasswordValidationException((Throwable)ex);
            }
            catch (SecurityException ex) {
                throw new PasswordValidationCallback.PasswordValidationException((Throwable)ex);
            }
            try {
                loginContext.login();
                Subject subject = loginContext.getSubject();
                if (!subject.getPrincipals().isEmpty()) {
                    if (JaasPlainTextPasswordValidationCallbackHandler.this.logger.isDebugEnabled()) {
                        JaasPlainTextPasswordValidationCallbackHandler.this.logger.debug((Object)("Authentication request for user '" + username + "' successful"));
                    }
                    return true;
                }
                if (JaasPlainTextPasswordValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    JaasPlainTextPasswordValidationCallbackHandler.this.logger.debug((Object)("Authentication request for user '" + username + "' failed"));
                }
                return false;
            }
            catch (LoginException ex) {
                if (JaasPlainTextPasswordValidationCallbackHandler.this.logger.isDebugEnabled()) {
                    JaasPlainTextPasswordValidationCallbackHandler.this.logger.debug((Object)("Authentication request for user '" + username + "' failed"));
                }
                return false;
            }
        }
    }
}

