/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j.callback.acegi;

import java.io.IOException;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.UserCache;
import org.acegisecurity.providers.dao.cache.NullUserCache;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.support.AcegiUtils;
import org.springframework.ws.soap.security.wss4j.callback.AbstractWsPasswordCallbackHandler;
import org.springframework.ws.soap.security.wss4j.callback.UsernameTokenPrincipalCallback;

public class AcegiDigestPasswordValidationCallbackHandler
extends AbstractWsPasswordCallbackHandler
implements InitializingBean {
    private UserCache userCache = new NullUserCache();
    private UserDetailsService userDetailsService;

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"userDetailsService is required");
    }

    protected void handleUsernameToken(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        String identifier = callback.getIdentifier();
        UserDetails user = this.loadUserDetails(identifier);
        if (user != null) {
            AcegiUtils.checkUserValidity(user);
            callback.setPassword(user.getPassword());
        }
    }

    protected void handleUsernameTokenPrincipal(UsernameTokenPrincipalCallback callback) throws IOException, UnsupportedCallbackException {
        UserDetails user = this.loadUserDetails(callback.getPrincipal().getName());
        WSUsernameTokenPrincipal principal = callback.getPrincipal();
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)principal, (Object)principal.getPassword(), user.getAuthorities());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + authRequest.toString()));
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)authRequest);
    }

    protected void handleCleanup(CleanupCallback callback) throws IOException, UnsupportedCallbackException {
        SecurityContextHolder.clearContext();
    }

    private UserDetails loadUserDetails(String username) throws DataAccessException {
        UserDetails user = this.userCache.getUserFromCache(username);
        if (user == null) {
            try {
                user = this.userDetailsService.loadUserByUsername(username);
            }
            catch (UsernameNotFoundException notFound) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Username '" + username + "' not found"));
                }
                return null;
            }
            this.userCache.putUserInCache(user);
        }
        return user;
    }
}

