/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.springframework.jms.support.JmsUtils;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractReceiverConnection;
import org.springframework.ws.transport.jms.BytesMessageInputStream;
import org.springframework.ws.transport.jms.BytesMessageOutputStream;
import org.springframework.ws.transport.jms.JmsTransportException;
import org.springframework.ws.transport.jms.support.JmsTransportUtils;

public class JmsReceiverConnection
extends AbstractReceiverConnection {
    private final Message requestMessage;
    private final Session session;
    private Message responseMessage;
    private String textMessageEncoding;

    private JmsReceiverConnection(Message requestMessage, Session session) {
        Assert.notNull((Object)requestMessage, (String)"requestMessage must not be null");
        Assert.notNull((Object)session, (String)"session must not be null");
        this.requestMessage = requestMessage;
        this.session = session;
    }

    protected JmsReceiverConnection(BytesMessage requestMessage, Session session) {
        this((Message)requestMessage, session);
    }

    protected JmsReceiverConnection(TextMessage requestMessage, String encoding, Session session) {
        this((Message)requestMessage, session);
        this.textMessageEncoding = encoding;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    public URI getUri() throws URISyntaxException {
        try {
            return JmsTransportUtils.toUri(this.requestMessage.getJMSDestination());
        }
        catch (JMSException ex) {
            throw new URISyntaxException("", ex.getMessage());
        }
    }

    public String getErrorMessage() throws IOException {
        return null;
    }

    public boolean hasError() throws IOException {
        return false;
    }

    protected Iterator getRequestHeaderNames() throws IOException {
        try {
            return JmsTransportUtils.getHeaderNames(this.requestMessage);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not get property names", ex);
        }
    }

    protected Iterator getRequestHeaders(String name) throws IOException {
        try {
            return JmsTransportUtils.getHeaders(this.requestMessage, name);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not get property value", ex);
        }
    }

    protected InputStream getRequestInputStream() throws IOException {
        if (this.requestMessage instanceof BytesMessage) {
            return new BytesMessageInputStream((BytesMessage)this.requestMessage);
        }
        if (this.requestMessage instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)this.requestMessage;
            try {
                String text = textMessage.getText();
                byte[] contents = text != null ? text.getBytes(this.textMessageEncoding) : new byte[]{};
                return new ByteArrayInputStream(contents);
            }
            catch (JMSException ex) {
                throw new JmsTransportException(ex);
            }
        }
        throw new IllegalStateException("Unknown request message type [" + this.requestMessage + "]");
    }

    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        try {
            if (this.requestMessage instanceof BytesMessage) {
                this.responseMessage = this.session.createBytesMessage();
            } else if (this.requestMessage instanceof TextMessage) {
                this.responseMessage = this.session.createTextMessage();
            } else {
                throw new IllegalStateException("Unknown request message type [" + this.requestMessage + "]");
            }
            this.responseMessage.setJMSCorrelationID(this.requestMessage.getJMSMessageID());
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not create response message", ex);
        }
    }

    protected void addResponseHeader(String name, String value) throws IOException {
        try {
            JmsTransportUtils.addHeader(this.responseMessage, name, value);
        }
        catch (JMSException ex) {
            throw new JmsTransportException("Could not set property", ex);
        }
    }

    protected OutputStream getResponseOutputStream() throws IOException {
        if (this.responseMessage instanceof BytesMessage) {
            return new BytesMessageOutputStream((BytesMessage)this.responseMessage);
        }
        if (this.responseMessage instanceof TextMessage) {
            return new ByteArrayOutputStream(){

                public void close() throws IOException {
                    String text = new String(this.toByteArray(), JmsReceiverConnection.this.textMessageEncoding);
                    try {
                        ((TextMessage)JmsReceiverConnection.this.responseMessage).setText(text);
                    }
                    catch (JMSException ex) {
                        throw new JmsTransportException(ex);
                    }
                }
            };
        }
        throw new IllegalStateException("Unknown request message type [" + this.responseMessage + "]");
    }

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        MessageProducer messageProducer = null;
        try {
            if (this.requestMessage.getJMSReplyTo() != null) {
                messageProducer = this.session.createProducer(this.requestMessage.getJMSReplyTo());
                messageProducer.setDeliveryMode(this.requestMessage.getJMSDeliveryMode());
                messageProducer.setPriority(this.requestMessage.getJMSPriority());
                messageProducer.send(this.responseMessage);
            }
        }
        catch (JMSException ex) {
            throw new JmsTransportException(ex);
        }
        finally {
            JmsUtils.closeMessageProducer(messageProducer);
        }
    }
}

