/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.http.HttpExchangeConnection;
import org.springframework.ws.transport.support.SimpleWebServiceMessageReceiverObjectSupport;

public class WebServiceMessageReceiverHttpHandler
extends SimpleWebServiceMessageReceiverObjectSupport
implements HttpHandler {
    private boolean chunkedEncoding = false;

    public void setChunkedEncoding(boolean chunkedEncoding) {
        this.chunkedEncoding = chunkedEncoding;
    }

    public void handle(HttpExchange httpExchange) throws IOException {
        if ("POST".equals(httpExchange.getRequestMethod())) {
            HttpExchangeConnection connection = new HttpExchangeConnection(httpExchange);
            connection.setChunkedEncoding(this.chunkedEncoding);
            try {
                this.handleConnection((WebServiceConnection)connection);
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
            }
        } else {
            httpExchange.sendResponseHeaders(405, -1L);
            httpExchange.close();
        }
    }
}

