/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Iterator;
import org.jivesoftware.smack.packet.Message;
import org.springframework.util.Assert;

public abstract class XmppTransportUtils {
    private XmppTransportUtils() {
    }

    public static URI toUri(Message requestMessage) throws URISyntaxException {
        return new URI("xmpp", requestMessage.getTo(), null);
    }

    public static String getTo(URI uri) {
        return uri.getSchemeSpecificPart();
    }

    public static boolean hasError(Message message) {
        return message != null && Message.Type.error.equals((Object)message.getType());
    }

    public static String getErrorMessage(Message message) {
        if (message == null || !Message.Type.error.equals((Object)message.getType())) {
            return null;
        }
        return message.getBody();
    }

    public static void addHeader(Message message, String name, String value) {
        message.setProperty(name, (Object)value);
    }

    public static Iterator<String> getHeaderNames(Message message) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        return message.getPropertyNames().iterator();
    }

    public static Iterator<String> getHeaders(Message message, String name) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        String value = message.getProperty(name).toString();
        if (value != null) {
            return Collections.singletonList(value).iterator();
        }
        return Collections.emptyList().iterator();
    }
}

