/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Service;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.Transport;
import jakarta.mail.URLName;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.search.HeaderTerm;
import jakarta.mail.search.SearchTerm;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractSenderConnection;
import org.springframework.ws.transport.mail.MailTransportException;
import org.springframework.ws.transport.mail.support.MailTransportUtils;

public class MailSenderConnection
extends AbstractSenderConnection {
    private static final Log logger = LogFactory.getLog(MailSenderConnection.class);
    private final Session session;
    private MimeMessage requestMessage;
    private Message responseMessage;
    private String requestContentType;
    private boolean deleteAfterReceive = false;
    private final URLName storeUri;
    private final URLName transportUri;
    private ByteArrayOutputStream requestBuffer;
    private InternetAddress from;
    private final InternetAddress to;
    private String subject;
    private final long receiveTimeout;
    private Store store;
    private Folder folder;

    protected MailSenderConnection(Session session, URLName transportUri, URLName storeUri, InternetAddress to, long receiveTimeout) {
        Assert.notNull((Object)session, (String)"'session' must not be null");
        Assert.notNull((Object)transportUri, (String)"'transportUri' must not be null");
        Assert.notNull((Object)storeUri, (String)"'storeUri' must not be null");
        Assert.notNull((Object)to, (String)"'to' must not be null");
        this.session = session;
        this.transportUri = transportUri;
        this.storeUri = storeUri;
        this.to = to;
        this.receiveTimeout = receiveTimeout;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    void setFrom(InternetAddress from) {
        this.from = from;
    }

    void setSubject(String subject) {
        this.subject = subject;
    }

    public URI getUri() throws URISyntaxException {
        return MailTransportUtils.toUri(this.to, this.subject);
    }

    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        try {
            this.requestMessage = new MimeMessage(this.session);
            this.requestMessage.setRecipient(Message.RecipientType.TO, (Address)this.to);
            this.requestMessage.setSentDate(new Date());
            if (this.from != null) {
                this.requestMessage.setFrom((Address)this.from);
            }
            if (this.subject != null) {
                this.requestMessage.setSubject(this.subject);
            }
            this.requestBuffer = new ByteArrayOutputStream();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    public void addRequestHeader(String name, String value) throws IOException {
        try {
            this.requestMessage.addHeader(name, value);
            if ("Content-Type".equals(name)) {
                this.requestContentType = value;
            }
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    protected OutputStream getRequestOutputStream() throws IOException {
        return this.requestBuffer;
    }

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        Transport transport = null;
        try {
            this.requestMessage.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.requestContentType, this.requestBuffer.toByteArray())));
            transport = this.session.getTransport(this.transportUri);
            transport.connect();
            this.requestMessage.saveChanges();
            transport.sendMessage((Message)this.requestMessage, this.requestMessage.getAllRecipients());
        }
        catch (MessagingException ex) {
            try {
                throw new MailTransportException(ex);
            }
            catch (Throwable throwable) {
                MailTransportUtils.closeService(transport);
                throw throwable;
            }
        }
        MailTransportUtils.closeService((Service)transport);
    }

    protected void onReceiveBeforeRead() throws IOException {
        try {
            String requestMessageId = this.requestMessage.getMessageID();
            Assert.hasLength((String)requestMessageId, (String)("No Message-ID found on request message [" + this.requestMessage + "]"));
            try {
                Thread.sleep(this.receiveTimeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.openFolder();
            HeaderTerm searchTerm = new HeaderTerm("In-Reply-To", requestMessageId);
            Message[] responses = this.folder.search((SearchTerm)searchTerm);
            if (responses.length > 0) {
                if (responses.length > 1) {
                    logger.warn((Object)("Received more than one response for request with ID [" + requestMessageId + "]"));
                }
                this.responseMessage = responses[0];
            }
            if (this.deleteAfterReceive) {
                this.responseMessage.setFlag(Flags.Flag.DELETED, true);
            }
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    private void openFolder() throws MessagingException {
        this.store = this.session.getStore(this.storeUri);
        this.store.connect();
        this.folder = this.store.getFolder(this.storeUri);
        if (this.folder == null || !this.folder.exists()) {
            throw new IllegalStateException("No default folder to receive from");
        }
        if (this.deleteAfterReceive) {
            this.folder.open(2);
        } else {
            this.folder.open(1);
        }
    }

    protected boolean hasResponse() throws IOException {
        return this.responseMessage != null;
    }

    public Iterator<String> getResponseHeaderNames() throws IOException {
        try {
            ArrayList<String> headers = new ArrayList<String>();
            Enumeration enumeration = this.responseMessage.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = (Header)enumeration.nextElement();
                headers.add(header.getName());
            }
            return headers.iterator();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    public Iterator<String> getResponseHeaders(String name) throws IOException {
        try {
            String[] headers = this.responseMessage.getHeader(name);
            return Arrays.asList(headers).iterator();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    protected InputStream getResponseInputStream() throws IOException {
        try {
            return this.responseMessage.getDataHandler().getInputStream();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    public boolean hasError() throws IOException {
        return false;
    }

    public String getErrorMessage() throws IOException {
        return null;
    }

    public void onClose() throws IOException {
        MailTransportUtils.closeFolder(this.folder, this.deleteAfterReceive);
        MailTransportUtils.closeService((Service)this.store);
    }

    private class ByteArrayDataSource
    implements DataSource {
        private byte[] data;
        private String contentType;

        public ByteArrayDataSource(String contentType, byte[] data) {
            this.data = data;
            this.contentType = contentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return "ByteArrayDataSource";
        }
    }
}

