/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.support;

import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class SpringSecurityUtils {
    public static void checkUserValidity(UserDetails user) throws AccountExpiredException, CredentialsExpiredException, DisabledException, LockedException {
        if (!user.isAccountNonLocked()) {
            throw new LockedException("User account is locked", (Object)user);
        }
        if (!user.isEnabled()) {
            throw new DisabledException("User is disabled", (Object)user);
        }
        if (!user.isAccountNonExpired()) {
            throw new AccountExpiredException("User account has expired", (Object)user);
        }
        if (!user.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException("User credentials have expired", (Object)user);
        }
    }
}

