/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.server.endpoint.mapping.AbstractEndpointMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodEndpointMapping<T>
extends AbstractEndpointMapping {
    private final Map<T, MethodEndpoint> endpointMap = new HashMap<T, MethodEndpoint>();

    @Override
    protected Object getEndpointInternal(MessageContext messageContext) throws Exception {
        T key = this.getLookupKeyForMessage(messageContext);
        if (key == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up endpoint for [" + key + "]"));
        }
        return this.lookupEndpoint(key);
    }

    protected abstract T getLookupKeyForMessage(MessageContext var1) throws Exception;

    protected MethodEndpoint lookupEndpoint(T key) {
        return this.endpointMap.get(key);
    }

    protected void registerEndpoint(T key, MethodEndpoint endpoint) throws BeansException {
        MethodEndpoint mappedEndpoint = this.endpointMap.get(key);
        if (mappedEndpoint != null) {
            throw new ApplicationContextException("Cannot map endpoint [" + endpoint + "] on registration key [" + key + "]: there's already endpoint [" + mappedEndpoint + "] mapped");
        }
        if (endpoint == null) {
            throw new ApplicationContextException("Could not find endpoint for key [" + key + "]");
        }
        this.endpointMap.put(key, endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Mapped [" + key + "] onto endpoint [" + endpoint + "]"));
        }
    }

    protected void registerMethods(final Object endpoint) {
        Assert.notNull((Object)endpoint, (String)"'endpoint' must not be null");
        Class<?> endpointClass = this.getEndpointClass(endpoint);
        ReflectionUtils.doWithMethods(endpointClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Object key = AbstractMethodEndpointMapping.this.getLookupKeyForMethod(method);
                if (key != null) {
                    AbstractMethodEndpointMapping.this.registerEndpoint(key, new MethodEndpoint(endpoint, method));
                }
            }
        });
    }

    protected void registerMethods(String beanName) {
        Assert.hasText((String)beanName, (String)"'beanName' must not be empty");
        Class endpointType = this.getApplicationContext().getType(beanName);
        endpointType = ClassUtils.getUserClass((Class)endpointType);
        Set<Method> methods = this.findEndpointMethods(endpointType, new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                return AbstractMethodEndpointMapping.this.getLookupKeyForMethod(method) != null;
            }
        });
        for (Method method : methods) {
            T key = this.getLookupKeyForMethod(method);
            this.registerEndpoint(key, new MethodEndpoint(beanName, (BeanFactory)this.getApplicationContext(), method));
        }
    }

    private Set<Method> findEndpointMethods(Class<?> endpointType, final ReflectionUtils.MethodFilter endpointMethodFilter) {
        final LinkedHashSet<Method> endpointMethods = new LinkedHashSet<Method>();
        LinkedHashSet endpointTypes = new LinkedHashSet();
        Class specificEndpointType = null;
        if (!Proxy.isProxyClass(endpointType)) {
            endpointTypes.add(endpointType);
            specificEndpointType = endpointType;
        }
        endpointTypes.addAll(Arrays.asList(endpointType.getInterfaces()));
        for (Class clazz : endpointTypes) {
            final Class targetClass = specificEndpointType != null ? specificEndpointType : clazz;
            ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
                    Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
                    if (endpointMethodFilter.matches(specificMethod) && (bridgedMethod == specificMethod || !endpointMethodFilter.matches(bridgedMethod))) {
                        endpointMethods.add(specificMethod);
                    }
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return endpointMethods;
    }

    protected T getLookupKeyForMethod(Method method) {
        return null;
    }

    protected Class<?> getEndpointClass(Object endpoint) {
        if (AopUtils.isJdkDynamicProxy((Object)endpoint)) {
            throw new IllegalArgumentException(ClassUtils.getShortName(this.getClass()) + " does not work with JDK Dynamic Proxies. " + "Please use CGLIB proxies, by setting proxy-target-class=\"true\" on the aop:aspectj-autoproxy " + "or aop:config element.");
        }
        return AopUtils.getTargetClass((Object)endpoint);
    }
}

