/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.xpath.XPathExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class LocationTransformerObjectSupport
extends TransformerObjectSupport {
    private final Log logger = LogFactory.getLog(this.getClass());

    protected void transformLocations(XPathExpression xPathExpression, Document definitionDocument, HttpServletRequest request) {
        Assert.notNull((Object)xPathExpression, (String)"'xPathExpression' must not be null");
        Assert.notNull((Object)definitionDocument, (String)"'definitionDocument' must not be null");
        Assert.notNull((Object)request, (String)"'request' must not be null");
        List<Node> locationNodes = xPathExpression.evaluateAsNodeList(definitionDocument);
        for (Node locationNode : locationNodes) {
            Attr location;
            if (!(locationNode instanceof Attr) || !StringUtils.hasLength((String)(location = (Attr)locationNode).getValue())) continue;
            String newLocation = this.transformLocation(location.getValue(), request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transforming [" + location.getValue() + "] to [" + newLocation + "]"));
            }
            location.setValue(newLocation);
        }
    }

    protected String transformLocation(String location, HttpServletRequest request) {
        StringBuilder url = new StringBuilder(request.getScheme());
        url.append("://").append(request.getServerName()).append(':').append(request.getServerPort());
        if (location.startsWith("/")) {
            url.append(request.getContextPath()).append(location);
            return url.toString();
        }
        int idx = location.indexOf("://");
        if (idx != -1 && (idx = location.indexOf(47, idx + 3)) != -1) {
            String path = location.substring(idx);
            url.append(path);
            return url.toString();
        }
        return location;
    }
}

