/*
 * Decompiled with CFR 0.152.
 */
package org.statefulj.common.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FieldAccessor<T, V> {
    protected Class<T> clazz;
    protected Field field;
    protected Method getMethod;
    protected Method setMethod;

    public FieldAccessor(Class<T> clazz, Field field) {
        try {
            this.clazz = clazz;
            this.field = field;
            this.init(field, clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public V getValue(T object) {
        try {
            if (this.getMethod != null) {
                return (V)this.getMethod.invoke(object, new Object[0]);
            }
            return (V)this.field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void setValue(T object, V value) {
        try {
            if (this.setMethod != null) {
                this.setMethod.invoke(object, value);
            } else {
                this.field.set(object, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetMethod() {
        return this.getMethod;
    }

    public Method getSetMethod() {
        return this.setMethod;
    }

    protected void init(Field field, Class<T> clazz) throws IntrospectionException {
        PropertyDescriptor statePropertyDescriptor = null;
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (!propertyDescriptor.getName().equals(field.getName())) continue;
            statePropertyDescriptor = propertyDescriptor;
            break;
        }
        Method method = this.getMethod = statePropertyDescriptor != null ? statePropertyDescriptor.getReadMethod() : null;
        if (this.getMethod != null) {
            this.getMethod.setAccessible(true);
        }
        Method method2 = this.setMethod = statePropertyDescriptor != null ? statePropertyDescriptor.getWriteMethod() : null;
        if (this.setMethod != null) {
            this.setMethod.setAccessible(true);
        }
        if (this.getMethod == null || this.setMethod == null) {
            field.setAccessible(true);
        }
    }
}

