/*
 * Decompiled with CFR 0.152.
 */
package org.staxnav;

import java.util.Date;
import javax.xml.bind.DatatypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueType<V> {
    public static final ValueType<String> STRING = new ValueType<String>(){

        @Override
        protected String parse(String s) throws Exception {
            return s;
        }
    };
    public static final ValueType<String> TRIMMED_STRING = new ValueType<String>(){

        @Override
        protected String parse(String s) throws Exception {
            return s.trim();
        }
    };
    public static final ValueType<Boolean> BOOLEAN = new ValueType<Boolean>(){

        @Override
        protected Boolean parse(String s) throws Exception {
            return Boolean.parseBoolean(s.trim());
        }
    };
    public static final ValueType<Integer> INTEGER = new ValueType<Integer>(){

        @Override
        protected Integer parse(String s) throws Exception {
            return Integer.parseInt(s.trim());
        }
    };
    public static final ValueType<Date> DATE = new ValueType<Date>(){

        @Override
        protected Date parse(String s) throws Exception {
            return DatatypeConverter.parseDate((String)s).getTime();
        }
    };
    public static final ValueType<Date> DATE_TIME = new ValueType<Date>(){

        @Override
        protected Date parse(String s) throws Exception {
            return DatatypeConverter.parseDateTime((String)s).getTime();
        }
    };

    public static <E extends Enum<E>> ValueType<E> get(Class<E> enumClass) {
        return new EnumType<E>(enumClass);
    }

    protected ValueType() {
    }

    protected abstract V parse(String var1) throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EnumType<E extends Enum<E>>
    extends ValueType<E> {
        private final Class<E> enumType;

        public EnumType(Class<E> enumType) {
            this.enumType = enumType;
        }

        @Override
        protected E parse(String s) throws Exception {
            return Enum.valueOf(this.enumType, s.trim());
        }
    }
}

