/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HeadersParser {
    public static final String EMPTY_STRING = "";

    private HeadersParser() {
    }

    public static Map<String, List<String>> parseHeaders(InputStream headersSection, String charset) {
        String line;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        String name = null;
        StringBuffer value = null;
        while ((line = HeadersParser.readLine(headersSection, charset)) != null && line.trim().length() >= 1) {
            int colon;
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                if (value == null) continue;
                value.append(' ');
                value.append(line.trim());
                continue;
            }
            if (name != null) {
                HeadersParser.addHeader(headers, name, value.toString());
            }
            if ((colon = line.indexOf(":")) < 0) {
                throw new IllegalStateException("Unable to parse header: " + line);
            }
            name = line.substring(0, colon).trim();
            value = new StringBuffer(line.substring(colon + 1).trim());
        }
        if (name != null) {
            HeadersParser.addHeader(headers, name, value.toString());
        }
        return headers;
    }

    static void addHeader(Map<String, List<String>> headers, String name, String value) {
        String nameLc = name.toLowerCase();
        List<String> headerValues = headers.get(nameLc);
        if (headerValues == null) {
            headerValues = new ArrayList<String>();
            headers.put(nameLc, headerValues);
        }
        headerValues.add(value);
    }

    static byte[] readRawLine(InputStream inputStream) {
        try {
            int ch;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            while ((ch = inputStream.read()) >= 0) {
                buf.write(ch);
                if (ch != 10) continue;
            }
            if (buf.size() == 0) {
                return null;
            }
            return buf.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error reading the headers line", e);
        }
    }

    static String readLine(InputStream inputStream, String charset) {
        byte[] rawData = HeadersParser.readRawLine(inputStream);
        if (rawData == null) {
            return null;
        }
        int len = rawData.length;
        int offset = 0;
        if (len > 0 && rawData[len - 1] == 10) {
            ++offset;
            if (len > 1 && rawData[len - 2] == 13) {
                ++offset;
            }
        }
        return HeadersParser.getString(rawData, 0, len - offset, charset);
    }

    static String getString(byte[] data, int offset, int length, String charset) {
        if (data == null || data.length == 0) {
            return EMPTY_STRING;
        }
        if (charset != null && charset.length() > 0) {
            try {
                return new String(data, offset, length, charset);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new String(data, offset, length);
    }
}

