/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.utils.thread.ThreadUtils;

public class TioUtils {
    private static Logger log = LoggerFactory.getLogger(TioUtils.class);

    public static boolean checkBeforeIO(ChannelContext channelContext) {
        if (channelContext.isWaitingClose) {
            return false;
        }
        Boolean isopen = null;
        if (channelContext.asynchronousSocketChannel != null) {
            isopen = channelContext.asynchronousSocketChannel.isOpen();
            if (channelContext.isClosed || channelContext.isRemoved) {
                if (isopen.booleanValue()) {
                    try {
                        Tio.close(channelContext, "asynchronousSocketChannel is open, but channelContext isClosed: " + channelContext.isClosed + ", isRemoved: " + channelContext.isRemoved, ChannelContext.CloseCode.CHANNEL_NOT_OPEN);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
                log.info("{}, isopen:{}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, isopen, channelContext.isClosed, channelContext.isRemoved});
                return false;
            }
        } else {
            log.error("{}, \u8bf7\u68c0\u67e5\u6b64\u5f02\u5e38, asynchronousSocketChannel is null, isClosed:{}, isRemoved:{}, {} ", new Object[]{channelContext, channelContext.isClosed, channelContext.isRemoved, ThreadUtils.stackTrace()});
            return false;
        }
        if (!isopen.booleanValue()) {
            log.info("{}, \u53ef\u80fd\u5bf9\u65b9\u5173\u95ed\u4e86\u8fde\u63a5, isopen:{}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, isopen, channelContext.isClosed, channelContext.isRemoved});
            Tio.close(channelContext, "asynchronousSocketChannel is not open, \u53ef\u80fd\u5bf9\u65b9\u5173\u95ed\u4e86\u8fde\u63a5", ChannelContext.CloseCode.CHANNEL_NOT_OPEN);
            return false;
        }
        return true;
    }
}

