/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.atoms;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.mov.QuickTimeDictionary;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.atoms.SampleDescription;
import com.drew.metadata.mov.atoms.SampleDescriptionAtom;
import com.drew.metadata.mov.media.QuickTimeVideoDirectory;
import java.io.IOException;

public class VideoSampleDescriptionAtom
extends SampleDescriptionAtom<VideoSampleDescription> {
    public VideoSampleDescriptionAtom(SequentialReader reader, Atom atom) throws IOException {
        super(reader, atom);
    }

    @Override
    @NotNull
    VideoSampleDescription getSampleDescription(SequentialReader reader) throws IOException {
        return new VideoSampleDescription(reader);
    }

    public void addMetadata(QuickTimeVideoDirectory directory) {
        if (this.sampleDescriptions.size() == 0) {
            return;
        }
        VideoSampleDescription sampleDescription = (VideoSampleDescription)this.sampleDescriptions.get(0);
        QuickTimeDictionary.setLookup(1, sampleDescription.vendor, directory);
        QuickTimeDictionary.setLookup(10, sampleDescription.dataFormat, directory);
        directory.setLong(2, sampleDescription.temporalQuality);
        directory.setLong(3, sampleDescription.spatialQuality);
        directory.setInt(4, sampleDescription.width);
        directory.setInt(5, sampleDescription.height);
        String compressorName = sampleDescription.compressorName.trim();
        if (!compressorName.isEmpty()) {
            directory.setString(8, compressorName);
        }
        directory.setInt(9, sampleDescription.depth);
        directory.setInt(13, sampleDescription.colorTableID);
        double horizontalInteger = (sampleDescription.horizontalResolution & 0xFFFFFFFFFFFF0000L) >> 16;
        double horizontalFraction = (double)(sampleDescription.horizontalResolution & 0xFFFFL) / Math.pow(2.0, 4.0);
        directory.setDouble(6, horizontalInteger + horizontalFraction);
        double verticalInteger = (sampleDescription.verticalResolution & 0xFFFFFFFFFFFF0000L) >> 16;
        double verticalFraction = (double)(sampleDescription.verticalResolution & 0xFFFFL) / Math.pow(2.0, 4.0);
        directory.setDouble(7, verticalInteger + verticalFraction);
    }

    static class VideoSampleDescription
    extends SampleDescription {
        int version;
        int revisionLevel;
        String vendor;
        long temporalQuality;
        long spatialQuality;
        int width;
        int height;
        long horizontalResolution;
        long verticalResolution;
        long dataSize;
        int frameCount;
        String compressorName;
        int depth;
        int colorTableID;

        public VideoSampleDescription(SequentialReader reader) throws IOException {
            super(reader);
            this.version = reader.getUInt16();
            this.revisionLevel = reader.getUInt16();
            this.vendor = reader.getString(4);
            this.temporalQuality = reader.getUInt32();
            this.spatialQuality = reader.getUInt32();
            this.width = reader.getUInt16();
            this.height = reader.getUInt16();
            this.horizontalResolution = reader.getUInt32();
            this.verticalResolution = reader.getUInt32();
            this.dataSize = reader.getUInt32();
            this.frameCount = reader.getUInt16();
            this.compressorName = reader.getString(32);
            this.depth = reader.getUInt16();
            this.colorTableID = reader.getInt16();
        }
    }
}

