/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.chromadb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;

public class ChromaDBContainer
extends GenericContainer<ChromaDBContainer> {
    private static final Logger log = LoggerFactory.getLogger(ChromaDBContainer.class);
    private static final DockerImageName DEFAULT_DOCKER_IMAGE = DockerImageName.parse((String)"chromadb/chroma");
    private static final DockerImageName GHCR_DOCKER_IMAGE = DockerImageName.parse((String)"ghcr.io/chroma-core/chroma");

    public ChromaDBContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public ChromaDBContainer(DockerImageName dockerImageName) {
        this(dockerImageName, ChromaDBContainer.isVersion2(dockerImageName.getVersionPart()));
    }

    public ChromaDBContainer(DockerImageName dockerImageName, boolean isVersion2) {
        super(dockerImageName);
        String apiPath = isVersion2 ? "/api/v2/heartbeat" : "/api/v1/heartbeat";
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_DOCKER_IMAGE, GHCR_DOCKER_IMAGE});
        this.withExposedPorts(new Integer[]{8000});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)apiPath));
    }

    public String getEndpoint() {
        return "http://" + this.getHost() + ":" + this.getFirstMappedPort();
    }

    private static boolean isVersion2(String version) {
        if (version.equals("latest")) {
            return true;
        }
        ComparableVersion comparableVersion = new ComparableVersion(version);
        if (comparableVersion.isGreaterThanOrEqualTo("1.0.0")) {
            return true;
        }
        log.warn("Version {} is less than 1.0.0 or not a semantic version.", (Object)version);
        return false;
    }
}

