/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;

public class InfluxDBContainer<SELF extends InfluxDBContainer<SELF>>
extends GenericContainer<SELF> {
    public static final Integer INFLUXDB_PORT = 8086;
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"influxdb");
    private static final String DEFAULT_TAG = "1.4.3";
    @Deprecated
    public static final String VERSION = "1.4.3";
    private static final int NO_CONTENT_STATUS_CODE = 204;
    private String username = "test-user";
    private String password = "test-password";
    private boolean authEnabled = true;
    private String admin = "admin";
    private String adminPassword = "password";
    private String database;
    private String bucket = "test-bucket";
    private String organization = "test-org";
    private Optional<String> retention = Optional.empty();
    private Optional<String> adminToken = Optional.empty();
    private final boolean isAtLeastMajorVersion2;

    @Deprecated
    public InfluxDBContainer() {
        this(DEFAULT_IMAGE_NAME.withTag("1.4.3"));
    }

    @Deprecated
    public InfluxDBContainer(String version) {
        this(DEFAULT_IMAGE_NAME.withTag(version));
    }

    public InfluxDBContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.waitStrategy = new HttpWaitStrategy().forPath("/ping").withBasicCredentials(this.username, this.password).forStatusCode(204);
        this.isAtLeastMajorVersion2 = new ComparableVersion(dockerImageName.getVersionPart()).isGreaterThanOrEqualTo("2.0.0");
        this.addExposedPort(INFLUXDB_PORT);
    }

    protected void configure() {
        if (this.isAtLeastMajorVersion2) {
            this.configureInfluxDBV2();
        } else {
            this.configureInfluxDBV1();
        }
    }

    private void configureInfluxDBV2() {
        this.addEnv("DOCKER_INFLUXDB_INIT_MODE", "setup");
        this.addEnv("DOCKER_INFLUXDB_INIT_USERNAME", this.username);
        this.addEnv("DOCKER_INFLUXDB_INIT_PASSWORD", this.password);
        this.addEnv("DOCKER_INFLUXDB_INIT_ORG", this.organization);
        this.addEnv("DOCKER_INFLUXDB_INIT_BUCKET", this.bucket);
        this.retention.ifPresent(ret -> this.addEnv("DOCKER_INFLUXDB_INIT_RETENTION", (String)ret));
        this.adminToken.ifPresent(token -> this.addEnv("DOCKER_INFLUXDB_INIT_ADMIN_TOKEN", (String)token));
    }

    private void configureInfluxDBV1() {
        this.addEnv("INFLUXDB_USER", this.username);
        this.addEnv("INFLUXDB_USER_PASSWORD", this.password);
        this.addEnv("INFLUXDB_HTTP_AUTH_ENABLED", String.valueOf(this.authEnabled));
        this.addEnv("INFLUXDB_ADMIN_USER", this.admin);
        this.addEnv("INFLUXDB_ADMIN_PASSWORD", this.adminPassword);
        this.addEnv("INFLUXDB_DB", this.database);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Collections.singleton(this.getMappedPort(INFLUXDB_PORT));
    }

    public InfluxDBContainer<SELF> withUsername(String username) {
        this.username = username;
        return this;
    }

    public InfluxDBContainer<SELF> withPassword(String password) {
        this.password = password;
        return this;
    }

    public InfluxDBContainer<SELF> withAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
        return (InfluxDBContainer)this.self();
    }

    public InfluxDBContainer<SELF> withAdmin(String admin) {
        this.admin = admin;
        return (InfluxDBContainer)this.self();
    }

    public InfluxDBContainer<SELF> withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (InfluxDBContainer)this.self();
    }

    public InfluxDBContainer<SELF> withDatabase(String database) {
        this.database = database;
        return (InfluxDBContainer)this.self();
    }

    public InfluxDBContainer<SELF> withOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public InfluxDBContainer<SELF> withBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public InfluxDBContainer<SELF> withRetention(String retention) {
        this.retention = Optional.of(retention);
        return this;
    }

    public InfluxDBContainer<SELF> withAdminToken(String adminToken) {
        this.adminToken = Optional.of(adminToken);
        return this;
    }

    public String getUrl() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(INFLUXDB_PORT);
    }

    @Deprecated
    public InfluxDB getNewInfluxDB() {
        InfluxDB influxDB = InfluxDBFactory.connect((String)this.getUrl(), (String)this.username, (String)this.password);
        influxDB.setDatabase(this.database);
        return influxDB;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getOrganization() {
        return this.organization;
    }

    public Optional<String> getRetention() {
        return this.retention;
    }

    public Optional<String> getAdminToken() {
        return this.adminToken;
    }
}

