/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.scylladb;

import java.net.InetSocketAddress;
import java.util.Optional;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class ScyllaDBContainer
extends GenericContainer<ScyllaDBContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"scylladb/scylla");
    private static final Integer CQL_PORT = 9042;
    private static final Integer SHARD_AWARE_PORT = 19042;
    private static final Integer ALTERNATOR_PORT = 8000;
    private static final String COMMAND = "--developer-mode=1 --overprovisioned=1";
    private static final String CONTAINER_CONFIG_LOCATION = "/etc/scylla";
    private boolean alternatorEnabled = false;
    private String configLocation;

    public ScyllaDBContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public ScyllaDBContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{CQL_PORT, SHARD_AWARE_PORT});
        this.withCommand(COMMAND);
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*initialization completed..*", (int)1));
    }

    protected void configure() {
        if (this.alternatorEnabled) {
            this.addExposedPort(8000);
            String newCommand = "--developer-mode=1 --overprovisioned=1 --alternator-port=" + ALTERNATOR_PORT + " --alternator-write-isolation=always";
            this.withCommand(newCommand);
        }
        Optional.ofNullable(this.configLocation).map(MountableFile::forClasspathResource).ifPresent(mountableFile -> this.withCopyFileToContainer((MountableFile)mountableFile, CONTAINER_CONFIG_LOCATION));
    }

    public ScyllaDBContainer withConfigurationOverride(String configLocation) {
        this.configLocation = configLocation;
        return this;
    }

    public ScyllaDBContainer withSsl(MountableFile certificate, MountableFile keyfile, MountableFile truststore) {
        this.withCopyFileToContainer(certificate, "/etc/scylla/scylla.cer.pem");
        this.withCopyFileToContainer(keyfile, "/etc/scylla/scylla.key.pem");
        this.withCopyFileToContainer(truststore, "/etc/scylla/scylla.truststore");
        this.withEnv("SSL_CERTFILE", "/etc/scylla/scylla.cer.pem");
        return this;
    }

    public ScyllaDBContainer withAlternator() {
        this.alternatorEnabled = true;
        return this;
    }

    public InetSocketAddress getContactPoint() {
        return new InetSocketAddress(this.getHost(), (int)this.getMappedPort(CQL_PORT));
    }

    public InetSocketAddress getShardAwareContactPoint() {
        return new InetSocketAddress(this.getHost(), (int)this.getMappedPort(SHARD_AWARE_PORT));
    }

    public String getAlternatorEndpoint() {
        if (!this.alternatorEnabled) {
            throw new IllegalStateException("Alternator is not enabled");
        }
        return "http://" + this.getHost() + ":" + this.getMappedPort(ALTERNATOR_PORT);
    }
}

