/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.C;
import com.sun.glass.utils.NativeLibLoader;
import java.nio.ByteBuffer;
import java.security.Permission;

class LinuxSystem {
    private static Permission permission = new RuntimePermission("loadLibrary.*");
    private static LinuxSystem instance = new LinuxSystem();
    static final int O_RDONLY = 0;
    static final int O_WRONLY = 1;
    static final int O_RDWR = 2;
    static final int O_NONBLOCK = 2048;
    static final int SEEK_SET = 0;
    static final int _SC_LONG_BIT = 106;
    static final int FBIOGET_VSCREENINFO = 17920;
    static final int FBIOPUT_VSCREENINFO = 17921;
    static final int FBIOPAN_DISPLAY = 17926;
    static final int FBIOBLANK = 17937;
    static final int FB_BLANK_UNBLANK = 0;
    static final int FB_ACTIVATE_NOW = 0;
    static final int FB_ACTIVATE_VBL = 16;
    private static int __SID = 21248;
    static int I_FLUSH = __SID | 5;
    static int FLUSHRW = 3;
    static final int ENXIO = 6;
    static final int EAGAIN = 11;
    static final int RTLD_LAZY = 1;
    static final int RTLD_GLOBAL = 256;
    static final long PROT_READ = 1L;
    static final long PROT_WRITE = 2L;
    static final long MAP_PRIVATE = 2L;
    static final long MAP_ANONYMOUS = 32L;
    static final long MAP_SHARED = 1L;
    static final long MAP_FAILED = 0xFFFFFFFFL;
    static int S_IRWXU = 448;

    static LinuxSystem getLinuxSystem() {
        LinuxSystem.checkPermissions();
        return instance;
    }

    private static void checkPermissions() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(permission);
        }
    }

    private LinuxSystem() {
    }

    void loadLibrary() {
        NativeLibLoader.loadLibrary((String)"glass_monocle");
    }

    native void setenv(String var1, String var2, boolean var3);

    native long open(String var1, int var2);

    native int close(long var1);

    native long lseek(long var1, long var3, int var5);

    native long write(long var1, ByteBuffer var3, int var4, int var5);

    native long read(long var1, ByteBuffer var3, int var4, int var5);

    native long sysconf(int var1);

    native int EVIOCGABS(int var1);

    native int ioctl(long var1, int var3, long var4);

    native int IOW(int var1, int var2, int var3);

    native int IOR(int var1, int var2, int var3);

    native int IOWR(int var1, int var2, int var3);

    native int errno();

    native String strerror(int var1);

    native long dlopen(String var1, int var2);

    native String dlerror();

    native long dlsym(long var1, String var3);

    native int dlclose(long var1);

    native long mmap(long var1, long var3, long var5, long var7, long var9, long var11);

    native int munmap(long var1, long var3);

    native long memcpy(long var1, long var3, long var5);

    String getErrorMessage() {
        return this.strerror(this.errno());
    }

    native int mkfifo(String var1, int var2);

    static class FbVarScreenInfo
    extends C.Structure {
        FbVarScreenInfo() {
            LinuxSystem.checkPermissions();
        }

        @Override
        native int sizeof();

        native int getBitsPerPixel(long var1);

        native int getXRes(long var1);

        native int getYRes(long var1);

        native int getXResVirtual(long var1);

        native int getYResVirtual(long var1);

        native int getOffsetX(long var1);

        native int getOffsetY(long var1);

        native void setRes(long var1, int var3, int var4);

        native void setVirtualRes(long var1, int var3, int var4);

        native void setOffset(long var1, int var3, int var4);

        native void setActivate(long var1, int var3);

        native void setBitsPerPixel(long var1, int var3);

        native void setRed(long var1, int var3, int var4);

        native void setGreen(long var1, int var3, int var4);

        native void setBlue(long var1, int var3, int var4);

        native void setTransp(long var1, int var3, int var4);
    }

    static class InputAbsInfo
    extends C.Structure {
        InputAbsInfo() {
        }

        @Override
        native int sizeof();

        static native int getValue(long var0);

        static native int getMinimum(long var0);

        static native int getMaximum(long var0);

        static native int getFuzz(long var0);

        static native int getFlat(long var0);

        static native int getResolution(long var0);
    }
}

