/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.assertions.api;

import javafx.scene.paint.Color;
import org.assertj.core.api.AbstractAssert;
import org.testfx.assertions.api.Assertions;
import org.testfx.assertions.impl.Adapter;
import org.testfx.matcher.base.ColorMatchers;
import org.testfx.service.support.ColorMatcher;

public class AbstractColorAssert<SELF extends AbstractColorAssert<SELF>>
extends AbstractAssert<SELF, Color> {
    protected AbstractColorAssert(Color color, Class<?> selfType) {
        super((Object)color, selfType);
    }

    public SELF isColor(Color color) {
        Assertions.assertThat((Color)this.actual).is(Adapter.fromMatcher(ColorMatchers.isColor(color)));
        return (SELF)((Object)((AbstractColorAssert)this.myself));
    }

    public SELF isNotColor(Color color) {
        Assertions.assertThat((Color)this.actual).is(Adapter.fromInverseMatcher(ColorMatchers.isColor(color)));
        return (SELF)((Object)((AbstractColorAssert)this.myself));
    }

    public SELF isColor(Color color, ColorMatcher colorMatcher) {
        Assertions.assertThat((Color)this.actual).is(Adapter.fromMatcher(ColorMatchers.isColor(color, colorMatcher)));
        return (SELF)((Object)((AbstractColorAssert)this.myself));
    }

    public SELF isNotColor(Color color, ColorMatcher colorMatcher) {
        Assertions.assertThat((Color)this.actual).is(Adapter.fromInverseMatcher(ColorMatchers.isColor(color, colorMatcher)));
        return (SELF)((Object)((AbstractColorAssert)this.myself));
    }

    public SELF isColor(String namedColor) {
        Assertions.assertThat((Color)this.actual).is(Adapter.fromMatcher(ColorMatchers.isColor(namedColor)));
        return (SELF)((Object)((AbstractColorAssert)this.myself));
    }

    public SELF isNotColor(String namedColor) {
        Assertions.assertThat((Color)this.actual).is(Adapter.fromInverseMatcher(ColorMatchers.isColor(namedColor)));
        return (SELF)((Object)((AbstractColorAssert)this.myself));
    }

    public SELF hasClosestNamedColor(Color namedColor) {
        Assertions.assertThat((Color)this.actual).is(Adapter.fromMatcher(ColorMatchers.hasClosestNamedColor(namedColor)));
        return (SELF)((Object)((AbstractColorAssert)this.myself));
    }

    public SELF doesNotHaveClosestNamedColor(Color namedColor) {
        Assertions.assertThat((Color)this.actual).is(Adapter.fromInverseMatcher(ColorMatchers.hasClosestNamedColor(namedColor)));
        return (SELF)((Object)((AbstractColorAssert)this.myself));
    }

    public SELF hasClosestNamedColor(String namedColor) {
        Assertions.assertThat((Color)this.actual).is(Adapter.fromMatcher(ColorMatchers.hasClosestNamedColor(namedColor)));
        return (SELF)((Object)((AbstractColorAssert)this.myself));
    }

    public SELF doesNotHaveClosestNamedColor(String namedColor) {
        Assertions.assertThat((Color)this.actual).is(Adapter.fromInverseMatcher(ColorMatchers.hasClosestNamedColor(namedColor)));
        return (SELF)((Object)((AbstractColorAssert)this.myself));
    }
}

