/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.robot.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import org.testfx.robot.KeyboardRobot;
import org.testfx.robot.SleepRobot;
import org.testfx.robot.TypeRobot;

public class TypeRobotImpl
implements TypeRobot {
    private static final long SLEEP_AFTER_KEY_CODE_IN_MILLIS = 25L;
    private final KeyboardRobot keyboardRobot;
    private final SleepRobot sleepRobot;

    public TypeRobotImpl(KeyboardRobot keyboardRobot, SleepRobot sleepRobot) {
        Objects.requireNonNull(keyboardRobot, "keyboardRobot must not be null");
        Objects.requireNonNull(sleepRobot, "sleepRobot must not be null");
        this.keyboardRobot = keyboardRobot;
        this.sleepRobot = sleepRobot;
    }

    @Override
    public void push(KeyCode ... combination) {
        this.pushKeyCodeCombination(combination);
    }

    @Override
    public void push(KeyCodeCombination combination) {
        this.pushKeyCodeCombination(combination);
    }

    @Override
    public void type(KeyCode ... keys) {
        for (KeyCode keyCode : keys) {
            this.pushKeyCode(keyCode);
            this.sleepRobot.sleep(25L);
        }
    }

    @Override
    public void type(KeyCode key, int times) {
        for (int index = 0; index < times; ++index) {
            this.pushKeyCode(key);
            this.sleepRobot.sleep(25L);
        }
    }

    private void pushKeyCode(KeyCode keyCode) {
        this.keyboardRobot.pressNoWait(keyCode);
        this.keyboardRobot.release(keyCode);
    }

    private void pushKeyCodeCombination(KeyCode ... keyCodeCombination) {
        List<KeyCode> keyCodesForwards = Arrays.asList(keyCodeCombination);
        ArrayList<KeyCode> keyCodesBackwards = new ArrayList<KeyCode>(keyCodesForwards);
        Collections.reverse(keyCodesBackwards);
        this.keyboardRobot.press(keyCodesForwards.toArray(new KeyCode[0]));
        this.keyboardRobot.release(keyCodesBackwards.toArray(new KeyCode[0]));
    }

    private void pushKeyCodeCombination(KeyCodeCombination keyCodeCombination) {
        List<KeyCode> keyCodes = this.filterKeyCodes(keyCodeCombination);
        this.pushKeyCodeCombination(keyCodes.toArray(new KeyCode[0]));
    }

    private List<KeyCode> filterKeyCodes(KeyCodeCombination keyCombination) {
        ArrayList<KeyCode> modifierKeyCodes = new ArrayList<KeyCode>();
        if (keyCombination.getShift() == KeyCombination.SHIFT_DOWN.getValue()) {
            modifierKeyCodes.add(KeyCode.SHIFT);
        }
        if (keyCombination.getAlt() == KeyCombination.ALT_DOWN.getValue()) {
            modifierKeyCodes.add(KeyCode.ALT);
        }
        if (keyCombination.getMeta() == KeyCombination.META_DOWN.getValue()) {
            modifierKeyCodes.add(KeyCode.META);
        }
        if (keyCombination.getShortcut() == KeyCombination.SHORTCUT_DOWN.getValue()) {
            modifierKeyCodes.add(KeyCode.SHORTCUT);
        }
        if (keyCombination.getControl() == KeyCombination.CONTROL_DOWN.getValue()) {
            modifierKeyCodes.add(KeyCode.CONTROL);
        }
        modifierKeyCodes.add(keyCombination.getCode());
        return Collections.unmodifiableList(modifierKeyCodes);
    }
}

