/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.robot.impl;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.stage.Window;
import org.testfx.robot.BaseRobot;
import org.testfx.robot.SleepRobot;
import org.testfx.robot.WriteRobot;
import org.testfx.service.finder.WindowFinder;
import org.testfx.util.WaitForAsyncUtils;

public class WriteRobotImpl
implements WriteRobot {
    private static final int SLEEP_AFTER_CHARACTER_IN_MILLIS;
    private final BaseRobot baseRobot;
    private final SleepRobot sleepRobot;
    private final WindowFinder windowFinder;

    public WriteRobotImpl(BaseRobot baseRobot, SleepRobot sleepRobot, WindowFinder windowFinder) {
        Objects.requireNonNull(baseRobot, "baseRobot must not be null");
        Objects.requireNonNull(sleepRobot, "sleepRobot must not be null");
        Objects.requireNonNull(windowFinder, "windowFinder must not be null");
        this.baseRobot = baseRobot;
        this.sleepRobot = sleepRobot;
        this.windowFinder = windowFinder;
    }

    @Override
    public void write(char character) {
        Scene scene = this.fetchTargetWindow().getScene();
        this.typeCharacterInScene(character, scene);
    }

    @Override
    public void write(String text) {
        this.write(text, SLEEP_AFTER_CHARACTER_IN_MILLIS);
    }

    @Override
    public void write(String text, int sleepMillis) {
        Scene scene = this.fetchTargetWindow().getScene();
        Iterator iterator = text.chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toList()).iterator();
        while (iterator.hasNext()) {
            char character = ((Character)iterator.next()).charValue();
            this.typeCharacterInScene(character, scene);
            this.sleepRobot.sleep(sleepMillis);
        }
    }

    private Window fetchTargetWindow() {
        Window targetWindow = this.windowFinder.window(Window::isFocused);
        if (targetWindow == null) {
            targetWindow = this.windowFinder.targetWindow();
        }
        if (targetWindow == null) {
            targetWindow = this.windowFinder.window(0);
        }
        return targetWindow;
    }

    private void typeCharacterInScene(char character, Scene scene) {
        KeyCode key = this.determineKeyCode(character);
        this.baseRobot.typeKeyboard(scene, key, Character.toString(character));
        WaitForAsyncUtils.waitForFxEvents();
    }

    private KeyCode determineKeyCode(char character) {
        KeyCode key = KeyCode.UNDEFINED;
        key = character == '\n' ? KeyCode.ENTER : key;
        key = character == '\t' ? KeyCode.TAB : key;
        return key;
    }

    static {
        int writeSleep;
        try {
            writeSleep = Integer.getInteger("testfx.robot.write_sleep", 25);
        }
        catch (NumberFormatException e) {
            System.err.println("\"testfx.robot.write_sleep\" property must be a number but was: \"" + System.getProperty("testfx.robot.write_sleep") + "\".\nUsing default of \"25\" milliseconds.");
            e.printStackTrace();
            writeSleep = 25;
        }
        SLEEP_AFTER_CHARACTER_IN_MILLIS = writeSleep;
    }
}

