/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.adapter.impl;

import javafx.geometry.Rectangle2D;
import javafx.scene.image.Image;
import org.testfx.service.adapter.RobotAdapter;
import org.testfx.service.adapter.impl.PrivateGlassRobotAdapter;
import org.testfx.service.adapter.impl.PublicGlassRobotAdapter;
import org.testfx.util.WaitForAsyncUtils;

public abstract class GlassRobotAdapter
implements RobotAdapter {
    protected static final int RETRIEVAL_TIMEOUT_IN_MILLIS = 10000;
    protected Object glassRobot;
    private static boolean publicRobot;

    public static GlassRobotAdapter createGlassRobot() {
        if (publicRobot) {
            return new PublicGlassRobotAdapter();
        }
        return new PrivateGlassRobotAdapter();
    }

    @Override
    public final void mouseWheel(int wheelAmount) {
        WaitForAsyncUtils.asyncFx(() -> this.getRobot().getClass().getMethod("mouseWheel", Integer.TYPE).invoke(this.getRobot(), wheelAmount));
    }

    @Override
    public final Image getCaptureRegion(Rectangle2D region) {
        return this.getScreenCapture(region, false);
    }

    public final Image getCaptureRegionRaw(Rectangle2D region) {
        return this.getScreenCapture(region, true);
    }

    protected final Object getRobot() {
        if (this.glassRobot == null) {
            this.robotCreate();
        }
        return this.glassRobot;
    }

    protected abstract Image getScreenCapture(Rectangle2D var1, boolean var2);

    static {
        try {
            Class.forName("com.sun.glass.ui.Robot");
            publicRobot = false;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("javafx.scene.robot.Robot");
                publicRobot = true;
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException("neither \"com.sun.glass.ui.Robot\" nor \"javafx.scene.robot.Robot\" could be found - please report this issue on https://github.com/TestFX/TestFX/issues with JDK version information (\"java -version\").");
            }
        }
    }
}

