/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.finder.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.testfx.internal.JavaVersionAdapter;
import org.testfx.service.finder.WindowFinder;

public class WindowFinderImpl
implements WindowFinder {
    private Window lastTargetWindow;

    @Override
    public Window targetWindow() {
        return this.lastTargetWindow;
    }

    @Override
    public void targetWindow(Window window) {
        this.lastTargetWindow = window;
    }

    @Override
    public void targetWindow(Predicate<Window> predicate) {
        this.targetWindow(this.window(predicate));
    }

    @Override
    public List<Window> listWindows() {
        return this.fetchWindowsInQueue();
    }

    @Override
    public List<Window> listTargetWindows() {
        return this.fetchWindowsByProximityTo(this.lastTargetWindow);
    }

    @Override
    public Window window(Predicate<Window> predicate) {
        return this.fetchWindowsByProximityTo(this.lastTargetWindow).stream().filter(predicate).findFirst().orElseThrow(NoSuchElementException::new);
    }

    @Override
    public void targetWindow(int windowIndex) {
        this.targetWindow(this.window(windowIndex));
    }

    @Override
    public void targetWindow(String stageTitleRegex) {
        this.targetWindow(this.window(stageTitleRegex));
    }

    @Override
    public void targetWindow(Pattern stageTitlePattern) {
        this.targetWindow(this.window(stageTitlePattern));
    }

    @Override
    public void targetWindow(Scene scene) {
        this.targetWindow(this.window(scene));
    }

    @Override
    public void targetWindow(Node node) {
        this.targetWindow(this.window(node));
    }

    @Override
    public Window window(int windowIndex) {
        List<Window> windows = this.fetchWindowsByProximityTo(this.lastTargetWindow);
        return windows.get(windowIndex);
    }

    @Override
    public Window window(String stageTitleRegex) {
        return this.window(this.hasStageTitlePredicate(stageTitleRegex));
    }

    @Override
    public Window window(Pattern stageTitlePattern) {
        return this.window(this.hasStageTitlePredicate(stageTitlePattern.toString()));
    }

    @Override
    public Window window(Scene scene) {
        return scene.getWindow();
    }

    @Override
    public Window window(Node node) {
        return this.window(node.getScene());
    }

    private List<Window> fetchWindowsInQueue() {
        return Collections.unmodifiableList(JavaVersionAdapter.getWindows());
    }

    private List<Window> fetchWindowsByProximityTo(Window targetWindow) {
        List<Window> windows = this.fetchWindowsInQueue();
        return this.orderWindowsByProximityTo(targetWindow, windows);
    }

    private List<Window> orderWindowsByProximityTo(Window targetWindow, List<Window> windows) {
        ArrayList<Window> copy = new ArrayList<Window>(windows);
        copy.sort(Comparator.comparingInt(w -> this.calculateWindowProximityTo(targetWindow, (Window)w)));
        return Collections.unmodifiableList(copy);
    }

    private int calculateWindowProximityTo(Window targetWindow, Window window) {
        if (window == targetWindow) {
            return 0;
        }
        if (this.isOwnerOf(window, targetWindow)) {
            return 1;
        }
        return 2;
    }

    private boolean isOwnerOf(Window window, Window targetWindow) {
        Window ownerWindow = this.retrieveOwnerOf(window);
        if (ownerWindow == targetWindow) {
            return true;
        }
        return ownerWindow != null && this.isOwnerOf(ownerWindow, targetWindow);
    }

    private Window retrieveOwnerOf(Window window) {
        if (window instanceof Stage) {
            return ((Stage)window).getOwner();
        }
        if (window instanceof PopupWindow) {
            return ((PopupWindow)window).getOwnerWindow();
        }
        return null;
    }

    private Predicate<Window> hasStageTitlePredicate(String stageTitleRegex) {
        return window -> window instanceof Stage && this.hasStageTitle((Stage)window, stageTitleRegex);
    }

    private boolean hasStageTitle(Stage stage, String stageTitleRegex) {
        return stage.getTitle() != null && stage.getTitle().matches(stageTitleRegex);
    }
}

