/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.stage.Screen;
import javafx.stage.Window;
import org.testfx.api.FxRobot;
import org.testfx.api.FxService;
import org.testfx.api.FxToolkit;
import org.testfx.service.support.CaptureSupport;
import org.testfx.service.support.FiredEvents;

public final class DebugUtils {
    private static final String DEFAULT_INDENT = "   ";
    private static final AtomicInteger DEFAULT_PHOTO_NUMBER = new AtomicInteger(0);

    private DebugUtils() {
    }

    @SafeVarargs
    public static Function<StringBuilder, StringBuilder> compose(Function<StringBuilder, StringBuilder> ... functions) {
        switch (functions.length) {
            case 0: {
                return Function.identity();
            }
            case 1: {
                return functions[0];
            }
        }
        return Arrays.stream(functions).reduce((accumulated, nextFunction) -> nextFunction.compose(accumulated)).orElse(Function.identity());
    }

    public static Function<StringBuilder, StringBuilder> runCode(Runnable runnable) {
        return sb -> {
            runnable.run();
            return sb;
        };
    }

    public static Function<StringBuilder, StringBuilder> insertHeader(String headerText) {
        return DebugUtils.insertHeader(headerText, DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> insertHeader(String headerText, String indent) {
        return sb -> sb.append("\n\n").append(indent).append(headerText);
    }

    public static Function<StringBuilder, StringBuilder> insertContent(String contentHeading, Object content) {
        return DebugUtils.insertContent(contentHeading, content, DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> insertContent(String contentHeading, Object content, String indent) {
        return sb -> sb.append("\n").append(indent).append(indent).append(contentHeading).append("\n").append(indent).append(indent).append(indent).append(content);
    }

    public static Function<StringBuilder, StringBuilder> insertContent(String contentHeading, Iterable<?> contentIter) {
        return DebugUtils.insertContent(contentHeading, contentIter, DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> insertContent(String contentHeading, Iterable<?> contentIter, String indent) {
        return sb -> {
            sb.append("\n").append(indent).append(indent).append(contentHeading);
            contentIter.forEach(content -> sb.append("\n").append(indent).append(indent).append(indent).append(content));
            return sb;
        };
    }

    public static Function<StringBuilder, StringBuilder> insertContent(String contentHeading, Object[] contentArray) {
        return DebugUtils.insertContent(contentHeading, contentArray, DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> insertContent(String contentHeading, Object[] contentArray, String indent) {
        return DebugUtils.insertContent(contentHeading, Stream.of(contentArray), indent);
    }

    public static Function<StringBuilder, StringBuilder> insertContent(String contentHeading, Stream<?> contentStream) {
        return DebugUtils.insertContent(contentHeading, contentStream, DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> insertContent(String contentHeading, Stream<?> contentStream, String indent) {
        return sb -> {
            sb.append("\n").append(indent).append(indent).append(contentHeading);
            contentStream.forEach(content -> sb.append("\n").append(indent).append(indent).append(indent).append(content));
            return sb;
        };
    }

    public static Function<StringBuilder, StringBuilder> showKeysPressedAtTestFailure(FxRobot robot) {
        return DebugUtils.showKeysPressedAtTestFailure(robot, DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> showKeysPressedAtTestFailure(FxRobot robot, String indent) {
        return sb -> {
            Set<KeyCode> keysPressed = robot.robotContext().getKeyboardRobot().getPressedKeys();
            return DebugUtils.insertContent("Keys pressed at test failure:", keysPressed, indent).apply((StringBuilder)sb);
        };
    }

    public static Function<StringBuilder, StringBuilder> showMouseButtonsPressedAtTestFailure(FxRobot robot) {
        return DebugUtils.showMouseButtonsPressedAtTestFailure(robot, DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> showMouseButtonsPressedAtTestFailure(FxRobot robot, String indent) {
        return sb -> {
            Set<MouseButton> mouseButtons = robot.robotContext().getMouseRobot().getPressedButtons();
            return DebugUtils.insertContent("Mouse Buttons pressed at test failure:", mouseButtons, indent).apply((StringBuilder)sb);
        };
    }

    public static Function<StringBuilder, StringBuilder> showFiredEvents() {
        return DebugUtils.showFiredEvents(DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> showFiredEvents(String indent) {
        return sb -> {
            List<Event> firedEvents = FxToolkit.toolkitContext().getFiredEvents();
            return DebugUtils.showFiredEvents(firedEvents, indent).apply((StringBuilder)sb);
        };
    }

    public static Function<StringBuilder, StringBuilder> showFiredEvents(FiredEvents events) {
        return DebugUtils.showFiredEvents(events, DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> showFiredEvents(FiredEvents events, String indent) {
        return DebugUtils.showFiredEvents(events.getEvents(), indent);
    }

    public static Function<StringBuilder, StringBuilder> showFiredEvents(List<Event> events) {
        return DebugUtils.showFiredEvents(events, DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> showFiredEvents(List<Event> events, String indent) {
        return DebugUtils.insertContent("Fired events since test began:", events, indent);
    }

    public static Function<CaptureSupport, Image> captureScreenshot() {
        return DebugUtils.captureScreenshot(Screen.getPrimary());
    }

    public static Function<CaptureSupport, Image> captureScreenshot(int screenIndex) {
        return DebugUtils.captureScreenshot((Screen)Screen.getScreens().get(screenIndex));
    }

    public static Function<CaptureSupport, Image> captureScreenshot(Screen screen) {
        return DebugUtils.captureBounds(screen.getBounds());
    }

    public static Function<CaptureSupport, Image> captureWindow() {
        return DebugUtils.captureWindow((Window)FxToolkit.toolkitContext().getRegisteredStage());
    }

    public static Function<CaptureSupport, Image> captureWindow(Window window) {
        return DebugUtils.captureBounds(DebugUtils.mapToRect2D(window));
    }

    public static Function<CaptureSupport, Image> captureBounds(Bounds bounds) {
        return DebugUtils.captureBounds(DebugUtils.mapToRect2D(bounds));
    }

    public static Function<CaptureSupport, Image> captureBounds(Rectangle2D bounds) {
        return captureSupport -> captureSupport.captureRegion(bounds);
    }

    public static Function<CaptureSupport, Image> captureNode(Node node) {
        return captureSupport -> captureSupport.captureNode(node);
    }

    public static Supplier<Path> defaultImagePath() {
        return DebugUtils.defaultImagePath("testfx-test", DEFAULT_PHOTO_NUMBER.getAndIncrement());
    }

    public static Supplier<Path> defaultImagePath(String testName) {
        return DebugUtils.defaultImagePath(testName, 0);
    }

    public static Supplier<Path> defaultImagePath(String testName, int photoNumber) {
        return () -> Paths.get(testName + " - " + photoNumber + ".png", new String[0]);
    }

    public static Function<StringBuilder, StringBuilder> saveScreenshot() {
        return DebugUtils.saveScreenshot(DebugUtils.defaultImagePath(), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveScreenshot(String testName) {
        return DebugUtils.saveScreenshot(testName, 0);
    }

    public static Function<StringBuilder, StringBuilder> saveScreenshot(String testName, int photoNumber) {
        return DebugUtils.saveScreenshot(DebugUtils.defaultImagePath(testName, photoNumber), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveScreenshot(Supplier<Path> capturedImagePath, String indent) {
        return DebugUtils.saveTestImage(DebugUtils.captureScreenshot(), capturedImagePath, indent);
    }

    public static Function<StringBuilder, StringBuilder> saveScreenshot(Screen screen, String testName, int photoNumber) {
        return DebugUtils.saveScreenshot(screen, DebugUtils.defaultImagePath(testName, photoNumber), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveScreenshot(Screen screen, Supplier<Path> capturedImagePath, String indent) {
        return DebugUtils.saveTestImage(DebugUtils.captureScreenshot(screen), capturedImagePath, indent);
    }

    public static Function<StringBuilder, StringBuilder> saveScreenshot(int screenIndex, String testName, int photoNumber) {
        return DebugUtils.saveScreenshot(screenIndex, DebugUtils.defaultImagePath(testName, photoNumber), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveScreenshot(int screenIndex, Supplier<Path> capturedImagePath, String indent) {
        return DebugUtils.saveTestImage(DebugUtils.captureScreenshot(screenIndex), capturedImagePath, indent);
    }

    public static Function<StringBuilder, StringBuilder> saveWindow() {
        return DebugUtils.saveWindow(DebugUtils.defaultImagePath(), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveWindow(String testName, int photoNumber) {
        return DebugUtils.saveWindow(DebugUtils.defaultImagePath(testName, photoNumber), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveWindow(Supplier<Path> capturedImagePath, String indent) {
        return DebugUtils.saveWindow((Window)FxToolkit.toolkitContext().getRegisteredStage(), capturedImagePath, indent);
    }

    public static Function<StringBuilder, StringBuilder> saveWindow(Window window, String testName, int photoNumber) {
        return DebugUtils.saveWindow(window, DebugUtils.defaultImagePath(testName, photoNumber), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveWindow(Window window, Supplier<Path> capturedImagePath, String indent) {
        return DebugUtils.saveTestImage(DebugUtils.captureWindow(window), capturedImagePath, indent);
    }

    public static Function<StringBuilder, StringBuilder> saveBounds(Bounds bounds) {
        return DebugUtils.saveBounds(bounds, DebugUtils.defaultImagePath(), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveBounds(Bounds bounds, String testName, int photoNumber) {
        return DebugUtils.saveBounds(bounds, DebugUtils.defaultImagePath(testName, photoNumber), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveBounds(Bounds bounds, Supplier<Path> capturedImagePath, String indent) {
        return DebugUtils.saveTestImage(DebugUtils.captureBounds(bounds), capturedImagePath, indent);
    }

    public static Function<StringBuilder, StringBuilder> saveBounds(Rectangle2D bounds) {
        return DebugUtils.saveBounds(bounds, DebugUtils.defaultImagePath(), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveBounds(Rectangle2D bounds, String testName, int photoNumber) {
        return DebugUtils.saveBounds(bounds, DebugUtils.defaultImagePath(testName, photoNumber), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveBounds(Rectangle2D bounds, Supplier<Path> capturedImagePath, String indent) {
        return DebugUtils.saveTestImage(DebugUtils.captureBounds(bounds), capturedImagePath, indent);
    }

    public static Function<StringBuilder, StringBuilder> saveNode(Node node) {
        return DebugUtils.saveNode(node, DebugUtils.defaultImagePath(), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveNode(Node node, String testName, int photoNumber) {
        return DebugUtils.saveNode(node, DebugUtils.defaultImagePath(testName, photoNumber), DEFAULT_INDENT);
    }

    public static Function<StringBuilder, StringBuilder> saveNode(Node node, Supplier<Path> capturedImagePath, String indent) {
        return DebugUtils.saveTestImage(DebugUtils.captureNode(node), capturedImagePath, indent);
    }

    public static Function<StringBuilder, StringBuilder> saveTestImage(Function<CaptureSupport, Image> captureImage, Supplier<Path> capturedImagePath, String indent) {
        return sb -> {
            CaptureSupport captureSupport = FxService.serviceContext().getCaptureSupport();
            Image errorImage = (Image)captureImage.apply(captureSupport);
            Path path = (Path)capturedImagePath.get();
            captureSupport.saveImage(errorImage, path);
            DebugUtils.insertContent("Test image saved at:", path.toAbsolutePath().toString(), indent).apply((StringBuilder)sb);
            return sb;
        };
    }

    public static Function<StringBuilder, StringBuilder> informedErrorMessage(FxRobot robot) {
        return DebugUtils.informedErrorMessage(robot, "Context:");
    }

    public static Function<StringBuilder, StringBuilder> informedErrorMessage(FxRobot robot, String headerText) {
        return DebugUtils.informedErrorMessage(headerText, true, true, robot, true, true);
    }

    public static Function<StringBuilder, StringBuilder> informedErrorMessage(String headerText, boolean takeScreenshot, boolean showFiredEvents, FxRobot robot, boolean showKeysPressed, boolean showMouseButtonsPressed) {
        Function function = Function.identity();
        if (headerText != null) {
            function = DebugUtils.insertHeader(headerText).compose(function);
        }
        if (takeScreenshot) {
            function = DebugUtils.saveScreenshot().compose(function);
        }
        if (showKeysPressed) {
            function = DebugUtils.showKeysPressedAtTestFailure(robot, DEFAULT_INDENT).compose(function);
        }
        if (showMouseButtonsPressed) {
            function = DebugUtils.showMouseButtonsPressedAtTestFailure(robot, DEFAULT_INDENT).compose(function);
        }
        if (showFiredEvents) {
            function = DebugUtils.showFiredEvents(DEFAULT_INDENT).compose(function);
        }
        return function;
    }

    private static Rectangle2D mapToRect2D(Bounds bounds) {
        return new Rectangle2D(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    private static Rectangle2D mapToRect2D(Window window) {
        return new Rectangle2D(window.getX(), window.getY(), window.getWidth(), window.getHeight());
    }
}

