/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.util;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;

public final class WaitForAsyncUtils {
    private static final long CONDITION_SLEEP_IN_MILLIS = 10L;
    private static final long SEMAPHORE_SLEEP_IN_MILLIS = 10L;
    private static final int SEMAPHORE_LOOPS_COUNT = 5;
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(new DefaultThreadFactory());
    private static final Queue<Throwable> EXCEPTIONS = new ConcurrentLinkedQueue<Throwable>();
    public static boolean printException = true;
    public static boolean autoCheckException = true;
    public static boolean checkAllExceptions = true;
    private static final boolean TRACE_FETCH = false;

    private static void setup() {
        if (checkAllExceptions) {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> WaitForAsyncUtils.registerException(e));
        } else {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> {});
        }
    }

    public static Future<Void> async(Runnable runnable) {
        if (autoCheckException) {
            WaitForAsyncUtils.checkExceptionWrapped();
        }
        ASyncFXCallable call = new ASyncFXCallable(runnable, true);
        return EXECUTOR_SERVICE.submit(call);
    }

    public static Future<Void> async(Runnable runnable, boolean throwExceptions) {
        if (autoCheckException) {
            WaitForAsyncUtils.checkExceptionWrapped();
        }
        ASyncFXCallable call = new ASyncFXCallable(runnable, throwExceptions);
        return EXECUTOR_SERVICE.submit(call);
    }

    public static <T> Future<T> async(Callable<T> callable) {
        if (autoCheckException) {
            WaitForAsyncUtils.checkExceptionWrapped();
        }
        ASyncFXCallable<T> call = new ASyncFXCallable<T>(callable, true);
        EXECUTOR_SERVICE.submit(call);
        return call;
    }

    public static <T> Future<T> async(Callable<T> callable, boolean throwExceptions) {
        if (autoCheckException) {
            WaitForAsyncUtils.checkExceptionWrapped();
        }
        ASyncFXCallable<T> call = new ASyncFXCallable<T>(callable, throwExceptions);
        return EXECUTOR_SERVICE.submit(call);
    }

    public static Future<Void> asyncFx(Runnable runnable) {
        if (autoCheckException) {
            WaitForAsyncUtils.checkExceptionWrapped();
        }
        ASyncFXCallable<Void> call = new ASyncFXCallable<Void>(runnable, true);
        WaitForAsyncUtils.runOnFxThread(call);
        return call;
    }

    public static <T> Future<T> asyncFx(Callable<T> callable) {
        if (autoCheckException) {
            WaitForAsyncUtils.checkExceptionWrapped();
        }
        ASyncFXCallable<T> call = new ASyncFXCallable<T>(callable, true);
        WaitForAsyncUtils.runOnFxThread(call);
        return call;
    }

    public static <T> T waitFor(Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException exception) {
            throw new RuntimeException(exception.getCause());
        }
        catch (InterruptedException ignore) {
            return null;
        }
    }

    public static <T> T waitFor(long timeout, TimeUnit timeUnit, Future<T> future) throws TimeoutException {
        try {
            return future.get(timeout, timeUnit);
        }
        catch (ExecutionException exception) {
            throw new RuntimeException(exception.getCause());
        }
        catch (InterruptedException ignore) {
            return null;
        }
    }

    public static void waitFor(long timeout, TimeUnit timeUnit, Callable<Boolean> condition) throws TimeoutException {
        Instant start = Instant.now();
        while (!WaitForAsyncUtils.callConditionAndReturnResult(condition)) {
            WaitForAsyncUtils.sleep(10L, TimeUnit.MILLISECONDS);
            if (Duration.between(start, Instant.now()).compareTo(Duration.of(timeout, WaitForAsyncUtils.chronoUnit(timeUnit))) < 0) continue;
            throw new TimeoutException();
        }
    }

    public static void waitFor(long timeout, TimeUnit timeUnit, ObservableBooleanValue booleanValue) throws TimeoutException {
        CompletableFuture future = new CompletableFuture();
        ChangeListener changeListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                future.complete(null);
            }
        };
        booleanValue.addListener(changeListener);
        if (!booleanValue.get()) {
            WaitForAsyncUtils.waitFor(timeout, timeUnit, future);
        }
        booleanValue.removeListener(changeListener);
    }

    public static void waitForFxEvents() {
        WaitForAsyncUtils.waitForFxEvents(5);
    }

    public static void waitForFxEvents(int attemptsCount) {
        for (int attempt = 0; attempt < attemptsCount; ++attempt) {
            WaitForAsyncUtils.blockFxThreadWithSemaphore();
            WaitForAsyncUtils.sleep(10L, TimeUnit.MILLISECONDS);
        }
    }

    public static void sleep(long duration, TimeUnit timeUnit) {
        try {
            Thread.sleep(timeUnit.toMillis(duration));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitForAsync(long millis, Runnable runnable) {
        Future<Void> future = WaitForAsyncUtils.async(runnable, false);
        WaitForAsyncUtils.waitForMillis(millis, future);
    }

    public static <T> T waitForAsync(long millis, Callable<T> callable) {
        Future<T> future = WaitForAsyncUtils.async(callable, false);
        return WaitForAsyncUtils.waitForMillis(millis, future);
    }

    public static void waitForAsyncFx(long millis, Runnable runnable) {
        Future<Void> future = WaitForAsyncUtils.asyncFx(runnable);
        WaitForAsyncUtils.waitForMillis(millis, future);
    }

    public static <T> T waitForAsyncFx(long millis, Callable<T> callable) {
        Future<T> future = WaitForAsyncUtils.asyncFx(callable);
        return WaitForAsyncUtils.waitForMillis(millis, future);
    }

    public static void checkException() throws Throwable {
        WaitForAsyncUtils.waitForFxEvents();
        Throwable throwable = WaitForAsyncUtils.getCheckException();
        if (throwable != null) {
            throw throwable;
        }
    }

    public static void clearExceptions() {
        EXCEPTIONS.clear();
    }

    private static void registerException(Throwable throwable) {
        if (checkAllExceptions) {
            if (throwable.getStackTrace()[0].getClassName().equals("com.sun.javafx.tk.quantum.PaintCollector")) {
                return;
            }
            if (printException) {
                WaitForAsyncUtils.printException(throwable, null);
            }
            EXCEPTIONS.add(new RuntimeException(throwable));
        }
    }

    private static void checkExceptionWrapped() {
        Throwable throwable = WaitForAsyncUtils.getCheckException();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    private static Throwable getCheckException() {
        if (EXCEPTIONS.peek() != null) {
            Throwable throwable = EXCEPTIONS.poll();
            StackTraceElement stackTraceElement = new StackTraceElement(WaitForAsyncUtils.class.getName(), "---- Delayed Exception: (See Trace Below) ----", WaitForAsyncUtils.class.getSimpleName() + ".java", 0);
            StackTraceElement[] stackTrace = new StackTraceElement[]{stackTraceElement};
            throwable.setStackTrace(stackTrace);
            return throwable;
        }
        return null;
    }

    private static <T> T waitForMillis(long millis, Future<T> future) {
        try {
            return WaitForAsyncUtils.waitFor(millis, TimeUnit.MILLISECONDS, future);
        }
        catch (TimeoutException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void runOnFxThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    private static boolean callConditionAndReturnResult(Callable<Boolean> condition) {
        try {
            return condition.call();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void blockFxThreadWithSemaphore() {
        Semaphore semaphore = new Semaphore(0);
        WaitForAsyncUtils.runOnFxThread(semaphore::release);
        try {
            semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void printException(Throwable e, StackTraceElement[] trace) {
        StringBuilder out = new StringBuilder("--- Exception in Async Thread ---\n");
        out.append(e.getClass().getName()).append(": ").append(e.getMessage()).append('\n');
        StackTraceElement[] st = e.getStackTrace();
        out.append(WaitForAsyncUtils.printTrace(st));
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            out.append(cause.getClass().getName()).append(": ").append(cause.getMessage()).append('\n');
            st = cause.getStackTrace();
            out.append(WaitForAsyncUtils.printTrace(st));
        }
        if (trace != null) {
            out.append("--- Trace of caller of unhandled exception in Async Thread ---\n");
            out.append(WaitForAsyncUtils.printTrace(trace));
        }
        System.err.println(out.toString());
    }

    private static String printTrace(StackTraceElement[] st) {
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement ste : st) {
            stackTrace.append("\t").append(ste.toString()).append("\n");
        }
        return stackTrace.toString();
    }

    private static ChronoUnit chronoUnit(TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        switch (unit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("unknown TimeUnit constant: " + (Object)((Object)unit));
    }

    static {
        WaitForAsyncUtils.setup();
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadCount = new AtomicInteger(1);

        private DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName(String.format("testfx-async-pool-thread-%d", this.threadCount.getAndIncrement()));
            return thread;
        }
    }

    private static class ASyncFXCallable<X>
    extends FutureTask<X>
    implements Callable<X> {
        private final boolean throwException;
        private final StackTraceElement[] trace;
        private Throwable exception;

        public ASyncFXCallable(Runnable runnable, boolean throwException) {
            super(runnable, null);
            this.throwException = throwException;
            this.trace = Thread.currentThread().getStackTrace();
        }

        public ASyncFXCallable(Callable<X> callable, boolean throwException) {
            super(callable);
            this.throwException = throwException;
            this.trace = Thread.currentThread().getStackTrace();
        }

        @Override
        protected void setException(Throwable throwable) {
            if (this.throwException) {
                if (printException) {
                    WaitForAsyncUtils.printException(throwable, this.trace);
                }
                this.exception = this.transformException(throwable);
                EXCEPTIONS.add(this.exception);
            }
            super.setException(throwable);
        }

        private Throwable transformException(Throwable exception) {
            if (exception instanceof ExecutionException) {
                return exception.getCause();
            }
            if (exception instanceof RuntimeException || exception instanceof Error) {
                return exception;
            }
            return new RuntimeException(exception);
        }

        @Override
        public X call() throws Exception {
            this.run();
            return this.get();
        }

        @Override
        public X get() throws InterruptedException, ExecutionException {
            try {
                return (X)super.get();
            }
            catch (Exception e) {
                if (this.exception != null) {
                    EXCEPTIONS.remove(this.exception);
                    this.exception = null;
                }
                throw e;
            }
        }

        @Override
        public X get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return (X)super.get(timeout, unit);
            }
            catch (Exception e) {
                if (this.exception != null) {
                    EXCEPTIONS.remove(this.exception);
                    this.exception = null;
                }
                throw e;
            }
        }
    }
}

