/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.robot.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.input.KeyCode;
import org.testfx.robot.BaseRobot;
import org.testfx.robot.KeyboardRobot;
import org.testfx.util.WaitForAsyncUtils;

public class KeyboardRobotImpl
implements KeyboardRobot {
    private static final KeyCode OS_SPECIFIC_SHORTCUT = System.getProperty("os.name").toLowerCase(Locale.US).startsWith("mac") ? KeyCode.COMMAND : KeyCode.CONTROL;
    private final BaseRobot baseRobot;
    private final Set<KeyCode> pressedKeys = ConcurrentHashMap.newKeySet();

    public KeyboardRobotImpl(BaseRobot baseRobot) {
        Objects.requireNonNull(baseRobot, "baseRobot must not be null");
        this.baseRobot = baseRobot;
    }

    @Override
    public void press(KeyCode ... keys) {
        Arrays.asList(keys).forEach(k -> {
            this.pressKey((KeyCode)k);
            WaitForAsyncUtils.waitForFxEvents();
        });
    }

    @Override
    public void pressNoWait(KeyCode ... keys) {
        Arrays.asList(keys).forEach(this::pressKey);
    }

    @Override
    public void release(KeyCode ... keys) {
        if (keys.length == 0) {
            this.pressedKeys.forEach(k -> {
                this.releaseKey((KeyCode)k);
                WaitForAsyncUtils.waitForFxEvents();
            });
        } else {
            Arrays.asList(keys).forEach(k -> {
                this.releaseKey((KeyCode)k);
                WaitForAsyncUtils.waitForFxEvents();
            });
        }
    }

    @Override
    public void releaseNoWait(KeyCode ... keys) {
        if (keys.length == 0) {
            this.pressedKeys.forEach(this::releaseKey);
        } else {
            Arrays.asList(keys).forEach(this::releaseKey);
        }
    }

    @Override
    public final Set<KeyCode> getPressedKeys() {
        return Collections.unmodifiableSet(this.pressedKeys);
    }

    private void pressKey(KeyCode keyCode) {
        KeyCode realKeyCode;
        KeyCode keyCode2 = realKeyCode = keyCode == KeyCode.SHORTCUT ? OS_SPECIFIC_SHORTCUT : keyCode;
        if (this.pressedKeys.add(realKeyCode)) {
            this.baseRobot.pressKeyboard(realKeyCode);
        }
    }

    private void releaseKey(KeyCode keyCode) {
        KeyCode realKeyCode;
        KeyCode keyCode2 = realKeyCode = keyCode == KeyCode.SHORTCUT ? OS_SPECIFIC_SHORTCUT : keyCode;
        if (this.pressedKeys.remove(realKeyCode)) {
            this.baseRobot.releaseKeyboard(realKeyCode);
        }
    }
}

