/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.service.query.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;
import org.hamcrest.Matcher;
import org.testfx.service.query.EmptyNodeQueryException;
import org.testfx.service.query.NodeQuery;
import org.testfx.util.NodeQueryUtils;

public class NodeQueryImpl
implements NodeQuery {
    private static final String CSS_ID_SELECTOR_PREFIX = "#";
    private static final String CSS_CLASS_SELECTOR_PREFIX = ".";
    private Set<Node> parentNodes = new LinkedHashSet<Node>();
    private final List<String> queryDescriptors = new ArrayList<String>();

    @Override
    public NodeQuery from(Node ... parentNodes) {
        this.parentNodes.addAll(Arrays.asList(parentNodes));
        this.queryDescriptors.add("from nodes: " + Arrays.toString(parentNodes));
        return this;
    }

    @Override
    public NodeQuery from(Collection<Node> parentNodes) {
        this.parentNodes.addAll(parentNodes);
        this.queryDescriptors.add("from nodes: " + parentNodes);
        return this;
    }

    @Override
    public NodeQuery lookup(String query) {
        Function<Node, Set<Node>> queryFunction = NodeQueryImpl.isCssSelector(query) ? NodeQueryUtils.bySelector(query) : NodeQueryUtils.byText(query);
        this.lookup(queryFunction);
        this.queryDescriptors.add("lookup by " + (NodeQueryImpl.isCssSelector(query) ? "selector" : "text") + ": \"" + query + "\"");
        return this;
    }

    @Override
    public <T> NodeQuery lookup(Matcher<T> matcher) {
        this.lookup(NodeQueryUtils.byMatcher(matcher));
        this.queryDescriptors.add("lookup by matcher: \"" + matcher + "\"");
        return this;
    }

    @Override
    public <T extends Node> NodeQuery lookup(Predicate<T> predicate) {
        this.lookup(NodeQueryUtils.byPredicate(predicate));
        this.queryDescriptors.add("lookup by predicate: \"" + predicate + "\"");
        return this;
    }

    @Override
    public NodeQuery lookup(Function<Node, Set<Node>> function) {
        this.parentNodes = this.parentNodes.stream().map(function).reduce((nodes, nodes2) -> {
            LinkedHashSet set = new LinkedHashSet(nodes);
            set.addAll(nodes2);
            return set;
        }).orElseGet(LinkedHashSet::new);
        this.queryDescriptors.add("lookup by function: \"" + function + "\"");
        return this;
    }

    @Override
    public <T> NodeQuery match(Matcher<T> matcher) {
        this.parentNodes = this.parentNodes.stream().filter(NodeQueryUtils.matchesMatcher(matcher)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.queryDescriptors.add("matching by matcher: " + matcher);
        return this;
    }

    @Override
    public <T extends Node> NodeQuery match(Predicate<T> predicate) {
        this.parentNodes = this.parentNodes.stream().filter(predicate).collect(Collectors.toCollection(LinkedHashSet::new));
        this.queryDescriptors.add("matching by predicate: " + predicate);
        return this;
    }

    @Override
    public NodeQuery nth(int index) {
        this.parentNodes = this.parentNodes.stream().skip(index).limit(1L).collect(Collectors.toCollection(LinkedHashSet::new));
        this.queryDescriptors.add("fetching the " + NodeQueryImpl.ordinal(index) + " node");
        return this;
    }

    @Override
    public <T extends Node> T query() {
        if (this.parentNodes.isEmpty()) {
            throw new EmptyNodeQueryException("there is no node in the scene-graph matching the query: " + this);
        }
        return (T)this.parentNodes.iterator().next();
    }

    @Override
    public <T extends Node> T queryAs(Class<T> clazz) {
        if (this.parentNodes.stream().noneMatch(node -> clazz.isAssignableFrom(node.getClass()))) {
            throw new EmptyNodeQueryException("there is no node in the scene-graph matching the query: " + this);
        }
        return (T)this.parentNodes.iterator().next();
    }

    @Override
    public <T extends Node> Optional<T> tryQuery() {
        if (this.parentNodes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.parentNodes.iterator().next());
    }

    @Override
    public <T extends Node> Optional<T> tryQueryAs(Class<T> clazz) {
        if (this.parentNodes.stream().noneMatch(node -> clazz.isAssignableFrom(node.getClass()))) {
            return Optional.empty();
        }
        return Optional.of(this.parentNodes.iterator().next());
    }

    @Override
    public <T extends Node> Set<T> queryAll() {
        return new LinkedHashSet<Node>(this.parentNodes);
    }

    @Override
    public <T extends Node> Set<T> queryAllAs(Class<T> clazz) {
        return new LinkedHashSet<Node>(this.parentNodes);
    }

    public String toString() {
        if (this.queryDescriptors.isEmpty()) {
            return "the empty NodeQuery";
        }
        return "NodeQuery: " + String.join((CharSequence)",\n", this.queryDescriptors);
    }

    private static boolean isCssSelector(String query) {
        return query.startsWith(CSS_ID_SELECTOR_PREFIX) || query.startsWith(CSS_CLASS_SELECTOR_PREFIX);
    }

    private static String ordinal(int i) {
        String[] sufixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (i % 100) {
            case 11: 
            case 12: 
            case 13: {
                return i + "th";
            }
        }
        return i + sufixes[i % 10];
    }
}

