/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.togglz.core.manager.FeatureManagerBuilder;
import org.togglz.core.manager.TogglzConfig;

public class FeatureManagerObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        TogglzConfig config = this.getConfiguration(obj);
        if (config == null) {
            throw new IllegalArgumentException("Unable to find TogglzConfig implementation..");
        }
        return new FeatureManagerBuilder().togglzConfig(config).build();
    }

    protected TogglzConfig getConfiguration(Object obj) {
        if (obj instanceof Reference) {
            Reference reference = (Reference)obj;
            Enumeration<RefAddr> addrs = reference.getAll();
            while (addrs.hasMoreElements()) {
                RefAddr refAddr = addrs.nextElement();
                if (!"togglzConfig".equals(refAddr.getType())) continue;
                String classname = refAddr.getContent().toString().trim();
                return (TogglzConfig)this.createInstance(classname);
            }
        }
        return null;
    }

    protected Object createInstance(String classname) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        try {
            return classLoader.loadClass(classname).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

