/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.logging;

import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.togglz.core.logging.Log;
import org.togglz.core.spi.LogProvider;
import org.togglz.core.util.Lists;
import org.togglz.core.util.Weighted;

public class LogFactory {
    private static volatile LogProvider _logProvider;

    public static Log getLog(Class<?> clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String name) {
        return LogFactory.getLogProvider().getLog(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogProvider getLogProvider() {
        if (_logProvider != null) return _logProvider;
        Class<LogFactory> clazz = LogFactory.class;
        synchronized (LogFactory.class) {
            if (_logProvider != null) return _logProvider;
            List<LogProvider> providers = Lists.asList(ServiceLoader.load(LogProvider.class).iterator());
            Collections.sort(providers, new Weighted.WeightedComparator());
            _logProvider = providers.get(0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return _logProvider;
        }
    }
}

