/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.annotation.EnabledByDefault;
import org.togglz.core.annotation.FeatureAttribute;
import org.togglz.core.annotation.InfoLink;
import org.togglz.core.annotation.Label;
import org.togglz.core.annotation.Owner;

public class FeatureAnnotations {
    public static String getLabel(Feature feature) {
        Label label = FeatureAnnotations.getAnnotation(feature, Label.class);
        if (label != null) {
            return label.value();
        }
        return feature.name();
    }

    public static String getOwner(Feature feature) {
        Owner owner = FeatureAnnotations.getAnnotation(feature, Owner.class);
        if (owner != null) {
            return owner.value();
        }
        return null;
    }

    public static String getInfoLink(Feature feature) {
        InfoLink infoLink = FeatureAnnotations.getAnnotation(feature, InfoLink.class);
        if (infoLink != null) {
            return infoLink.value();
        }
        return null;
    }

    public static boolean isEnabledByDefault(Feature feature) {
        return FeatureAnnotations.isAnnotationPresent(feature, EnabledByDefault.class);
    }

    public static boolean isAnnotationPresent(Feature feature, Class<? extends Annotation> annotationType) {
        return FeatureAnnotations.getAnnotation(feature, annotationType) != null;
    }

    public static Set<Annotation> getAnnotations(Feature feature) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        try {
            Class<?> featureClass = feature.getClass();
            Annotation[] fieldAnnotations = featureClass.getField(feature.name()).getAnnotations();
            Annotation[] classAnnotations = featureClass.getAnnotations();
            annotations.addAll(Arrays.asList(fieldAnnotations));
            annotations.addAll(Arrays.asList(classAnnotations));
            return annotations;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return annotations;
    }

    public static <A extends Annotation> A getAnnotation(Feature feature, Class<A> annotationType) {
        try {
            Class<?> featureClass = feature.getClass();
            A fieldAnnotation = featureClass.getField(feature.name()).getAnnotation(annotationType);
            A classAnnotation = featureClass.getAnnotation(annotationType);
            return fieldAnnotation != null ? fieldAnnotation : classAnnotation;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public static String[] getFeatureAttribute(Annotation annotation) {
        try {
            FeatureAttribute details = annotation.annotationType().getAnnotation(FeatureAttribute.class);
            if (details != null) {
                String attributeName = details.value();
                Method method = annotation.getClass().getMethod(details.annotationAttribute(), new Class[0]);
                if (method != null) {
                    String attributeValue = method.invoke((Object)annotation, new Object[0]).toString();
                    return new String[]{attributeName, attributeValue};
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }
}

