/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tomitribe.util.editor.Converter;

public class ObjectMap
extends AbstractMap<String, Object> {
    private final Object object;
    private Map<String, Map.Entry<String, Object>> attributes;
    private Set<Map.Entry<String, Object>> entries;

    public ObjectMap(Object object) {
        this(object.getClass(), object);
    }

    public ObjectMap(Class clazz) {
        this(clazz, null);
    }

    public ObjectMap(Class<?> clazz, Object object) {
        this.object = object;
        this.attributes = new HashMap<String, Map.Entry<String, Object>>();
        for (Field field : clazz.getFields()) {
            FieldEntry entry = new FieldEntry(field);
            this.attributes.put(entry.getKey(), entry);
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            try {
                if (!((Method)accessibleObject).getName().startsWith("get") || ((Method)accessibleObject).getParameterTypes().length != 0) continue;
                String name = ((Method)accessibleObject).getName().replaceFirst("get", "set");
                Method setter = clazz.getMethod(name, ((Method)accessibleObject).getReturnType());
                MethodEntry entry = new MethodEntry((Method)accessibleObject, setter);
                this.attributes.put(entry.getKey(), entry);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        this.entries = Collections.unmodifiableSet(new HashSet<Map.Entry<String, Object>>(this.attributes.values()));
    }

    @Override
    public Object get(Object key) {
        Map.Entry<String, Object> entry = this.attributes.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public Object put(String key, Object value) {
        Map.Entry<String, Object> entry = this.attributes.get(key);
        if (entry == null) {
            return null;
        }
        return entry.setValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entries;
    }

    public class MethodEntry
    implements Member<String, Object> {
        private final String key;
        private final Method getter;
        private final Method setter;

        public MethodEntry(Method getter, Method setter) {
            StringBuilder name = new StringBuilder(getter.getName());
            name.delete(0, 3);
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            this.key = name.toString();
            this.getter = getter;
            this.setter = setter;
        }

        protected Object invoke(Method method, Object ... args) {
            try {
                return method.invoke(ObjectMap.this.object, args);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.invoke(this.getter, new Object[0]);
        }

        @Override
        public Object setValue(Object value) {
            Object original = this.getValue();
            value = Converter.convert(value, this.setter.getParameterTypes()[0], this.getKey());
            this.invoke(this.setter, value);
            return original;
        }

        @Override
        public Class<?> getType() {
            return this.getter.getReturnType();
        }
    }

    public static interface Member<K, V>
    extends Map.Entry<K, V> {
        public Class<?> getType();
    }

    public class FieldEntry
    implements Member<String, Object> {
        private final Field field;

        public FieldEntry(Field field) {
            this.field = field;
        }

        @Override
        public String getKey() {
            return this.field.getName();
        }

        @Override
        public Object getValue() {
            try {
                return this.field.get(ObjectMap.this.object);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Object setValue(Object value) {
            try {
                Object replaced = this.getValue();
                value = Converter.convert(value, this.field.getType(), this.getKey());
                this.field.set(ObjectMap.this.object, value);
                return replaced;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }
    }
}

