/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<T>
implements Iterator<T> {
    private T next;

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            this.next = this.advance();
            return this.next != null;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T v = this.next;
        this.next = null;
        return v;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract T advance() throws NoSuchElementException;
}

