/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.editor;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.tomitribe.util.editor.AbstractConverter;
import org.tomitribe.util.editor.PropertyEditorException;

public class DateEditor
extends AbstractConverter {
    public static final Date NO_MIN = new Date(0L);
    public static final Date NO_MAX = new Date(Integer.MAX_VALUE);
    private List<DateFormat> formats = new ArrayList<DateFormat>();

    protected DateEditor(List<DateFormat> formats) {
        this.formats = formats;
    }

    public DateEditor() {
        this.formats.add(DateFormat.getInstance());
        this.formats.add(DateFormat.getDateInstance());
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd"));
        this.formats.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz"));
    }

    @Override
    protected Object toObjectImpl(String text) {
        if (text == null || text.isEmpty() || "0".equals(text)) {
            return NO_MIN;
        }
        if (Integer.valueOf(Integer.MAX_VALUE).toString().equals(text)) {
            return NO_MAX;
        }
        for (DateFormat format : this.formats) {
            try {
                return format.parse(text);
            }
            catch (ParseException e) {
            }
        }
        try {
            return this.complexParse(text);
        }
        catch (ParseException e) {
            throw new PropertyEditorException(e);
        }
    }

    private Object complexParse(String text) throws ParseException {
        String token;
        Locale locale = Locale.getDefault();
        int style = 2;
        int firstSpaceIndex = text.indexOf(32);
        if (firstSpaceIndex != -1 && (token = text.substring(0, firstSpaceIndex).intern()).startsWith("locale")) {
            String localeStr = token.substring(token.indexOf(61) + 1);
            int underscoreIndex = localeStr.indexOf(95);
            if (underscoreIndex != -1) {
                String language = localeStr.substring(0, underscoreIndex);
                String country = localeStr.substring(underscoreIndex + 1);
                locale = new Locale(language, country);
            } else {
                locale = new Locale(localeStr);
            }
            int nextSpaceIndex = text.indexOf(32, firstSpaceIndex + 1);
            token = text.substring(firstSpaceIndex + 1, nextSpaceIndex);
            String styleStr = token.substring(token.indexOf(61) + 1);
            style = "SHORT".equalsIgnoreCase(styleStr) ? 3 : ("MEDIUM".equalsIgnoreCase(styleStr) ? 2 : ("LONG".equalsIgnoreCase(styleStr) ? 1 : ("FULL".equalsIgnoreCase(styleStr) ? 0 : 2)));
            text = text.substring(nextSpaceIndex + 1);
        }
        DateFormat formats = DateFormat.getDateInstance(style, locale);
        return formats.parse(text);
    }

    protected String toStringImpl(Object value) {
        Date date = (Date)value;
        String text = this.formats.get(0).format(date);
        return text;
    }
}

