/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.twdata.maven.cli.RemoteCommand;
import org.twdata.maven.cli.config.CliClientConfigurationForm;

public class CliClientProjectComponent
implements ProjectComponent,
Configurable,
JDOMExternalizable {
    private final RemoteCommand[] commands = new RemoteCommand[]{new RemoteCommand("localhost", 4330, "compile resources jar install"), new RemoteCommand("localhost", 4331, "compile resources jar install"), new RemoteCommand("localhost", 4332, "compile resources jar install")};
    private CliClientConfigurationForm form;

    public CliClientProjectComponent(Project project) {
    }

    public void sendCommand(int index) {
        RemoteCommand cmd = this.commands[index - 1];
        try {
            Socket socket = new Socket(cmd.getHost(), cmd.getPort());
            OutputStream out = socket.getOutputStream();
            new PrintStream(out).append(cmd.getCommand()).append("\n");
            socket.close();
        }
        catch (IOException e1) {
            Messages.showMessageDialog((String)("Unable to send command to " + cmd.getHost() + " on port " + cmd.getPort() + ": " + e1.getMessage()), (String)"Error sending command", (Icon)Messages.getErrorIcon());
            e1.printStackTrace();
        }
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("org.twdata.maven.cli.CliClientProjectComponent" == null) {
            throw new IllegalStateException("@NotNull method org/twdata/maven/cli/CliClientProjectComponent.getComponentName must not return null");
        }
        return "org.twdata.maven.cli.CliClientProjectComponent";
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public RemoteCommand[] getRemoteCommands() {
        return this.commands;
    }

    @Nls
    public String getDisplayName() {
        return "Maven CLI Client";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        if (this.form == null) {
            this.form = new CliClientConfigurationForm();
        }
        return this.form.getRootComponent();
    }

    public boolean isModified() {
        return this.form != null && this.form.isModified(this);
    }

    public void apply() throws ConfigurationException {
        if (this.form != null) {
            this.form.getData(this);
        }
    }

    public void reset() {
        if (this.form != null) {
            this.form.setData(this);
        }
    }

    public void disposeUIResources() {
        this.form = null;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element cmds = element.getChild("commands");
        for (int x = 0; x < cmds.getChildren("command").size(); ++x) {
            this.commands[x] = new RemoteCommand((Element)cmds.getChildren().get(x));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element cmds = new Element("commands");
        for (RemoteCommand cmd : this.commands) {
            cmds.addContent((Content)cmd.toXml());
        }
        element.addContent((Content)cmds);
    }
}

