/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.ConsoleReader;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.shaded.mojoexecutor.MojoExecutor;
import org.twdata.maven.cli.CommandsCompletor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteCliMojo
extends AbstractMojo {
    private final Map<String, String> defaultAliases = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("compile", "org.apache.maven.plugins:maven-compiler-plugin:compile");
            this.put("testCompile", "org.apache.maven.plugins:maven-compiler-plugin:testCompile");
            this.put("jar", "org.apache.maven.plugins:maven-jar-plugin:jar");
            this.put("war", "org.apache.maven.plugins:maven-war-plugin:war");
            this.put("resources", "org.apache.maven.plugins:maven-resources-plugin:resources");
            this.put("testResources", "org.apache.maven.plugins:maven-resources-plugin:testResources");
            this.put("install", "org.apache.maven.plugins:maven-install-plugin:install");
            this.put("deploy", "org.apache.maven.plugins:maven-deploy-plugin:deploy");
            this.put("test", "org.apache.maven.plugins:maven-surefire-plugin:test");
            this.put("clean", "org.apache.maven.plugins:maven-clean-plugin:clean");
            this.put("help-system", "org.apache.maven.plugins:maven-help-plugin:system");
            this.put("help-effectivesettings", "org.apache.maven.plugins:maven-help-plugin:effective-settings");
            this.put("help-allprofiles", "org.apache.maven.plugins:maven-help-plugin:all-profiles");
            this.put("dependency-tree", "org.apache.maven.plugins:maven-dependency-plugin:tree");
            this.put("dependency-resolve", "org.apache.maven.plugins:maven-dependency-plugin:resolve");
            this.put("dependency-resolve-plugins", "org.apache.maven.plugins:maven-dependency-plugin:resolve-plugins");
            this.put("dependency-purge", "org.apache.maven.plugins:maven-dependency-plugin:purge-local-repository");
            this.put("dependency-analyze", "org.apache.maven.plugins:maven-dependency-plugin:analyze");
        }
    });
    private final List<String> listCommands = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("list");
            this.add("ls");
        }
    });
    private final List<String> exitCommands = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("quit");
            this.add("exit");
            this.add("bye");
        }
    });
    private static final String HELP_COMMAND = "?";
    private Map<String, String> commands;
    private String prompt;
    private String port = null;
    protected MavenProject project;
    protected MavenSession session;
    protected PluginManager pluginManager;
    protected List reactorProjects;
    private boolean acceptSocket = true;
    private ServerSocket server = null;

    public void execute() throws MojoExecutionException {
        Thread shell = new Thread(){

            public void run() {
                try {
                    ExecuteCliMojo.this.displayShell(System.in, System.out);
                    ExecuteCliMojo.this.acceptSocket = false;
                    if (ExecuteCliMojo.this.server != null) {
                        ExecuteCliMojo.this.server.close();
                    }
                }
                catch (MojoExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        shell.start();
        if (this.port != null) {
            try {
                this.server = new ServerSocket(Integer.parseInt(this.port));
            }
            catch (IOException e) {
                System.out.println("Cannot open port " + this.port + " for cli server: " + e);
            }
            this.openSocket(this.server, Integer.parseInt(this.port));
        }
        try {
            shell.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSocket(ServerSocket server, int port) throws MojoExecutionException {
        System.out.println("Opening port " + port + " for socket cli access");
        while (this.acceptSocket) {
            Socket connection = null;
            try {
                connection = server.accept();
                this.displayShell(connection.getInputStream(), new PrintStream(connection.getOutputStream()));
            }
            catch (IOException ex) {
                System.out.println("Server quit unexpectedly");
                ex.printStackTrace();
            }
            finally {
                if (connection == null) continue;
                try {
                    connection.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void displayShell(InputStream in, PrintStream out) throws MojoExecutionException {
        Map<String, String> aliases = this.buildCommands();
        ArrayList<String> availableCommands = new ArrayList<String>();
        availableCommands.addAll(aliases.keySet());
        availableCommands.addAll(this.exitCommands);
        availableCommands.addAll(this.listCommands);
        this.getLog().info((CharSequence)"Waiting for commands");
        try {
            String line;
            ConsoleReader reader = new ConsoleReader(in, new OutputStreamWriter(out));
            reader.addCompletor(new CommandsCompletor(availableCommands));
            reader.setDefaultPrompt((this.prompt != null ? this.prompt : "maven2") + "> ");
            while ((line = this.readCommand(reader)) != null) {
                if (StringUtils.isEmpty((String)line)) continue;
                if (this.exitCommands.contains(line)) break;
                if (this.listCommands.contains(line)) {
                    this.getLog().info((CharSequence)"Listing available projects: ");
                    for (Object reactorProject : this.reactorProjects) {
                        this.getLog().info((CharSequence)("* " + ((MavenProject)reactorProject).getArtifactId()));
                    }
                    continue;
                }
                if (HELP_COMMAND.equals(line)) {
                    this.printHelp();
                    continue;
                }
                ArrayList<MojoCall> calls = new ArrayList<MojoCall>();
                try {
                    ExecuteCliMojo.parseCommand(line, aliases, calls);
                }
                catch (IllegalArgumentException ex) {
                    this.getLog().error((CharSequence)("Invalid command: " + line));
                    continue;
                }
                try {
                    for (MojoCall call : calls) {
                        this.getLog().info((CharSequence)("Executing: " + call));
                        long start = System.currentTimeMillis();
                        MojoExecutor.executeMojo(MojoExecutor.plugin(MojoExecutor.groupId(call.getGroupId()), MojoExecutor.artifactId(call.getArtifactId()), MojoExecutor.version(call.getVersion(this.project))), MojoExecutor.goal(call.getGoal()), MojoExecutor.configuration(new MojoExecutor.Element[0]), MojoExecutor.executionEnvironment(this.project, this.session, this.pluginManager));
                        long now = System.currentTimeMillis();
                        this.getLog().info((CharSequence)("Current project: " + this.project.getArtifactId()));
                        this.getLog().info((CharSequence)("Execution time: " + (now - start) + " ms"));
                    }
                }
                catch (MojoExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute cli commands", (Exception)e);
        }
    }

    private Map<String, String> buildCommands() {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.putAll(this.defaultAliases);
        if (this.commands != null) {
            aliases.putAll(this.commands);
        }
        return aliases;
    }

    private void printHelp() {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        Map<String, String> commands = this.buildCommands();
        int maxLength = 0;
        for (String string : commands.keySet()) {
            maxLength = Math.max(maxLength, string.length());
        }
        pw.println("Commands: ");
        for (Map.Entry entry : this.buildCommands().entrySet()) {
            pw.print("  ");
            pw.print((String)entry.getKey());
            pw.print("  ");
            for (int x = 0; x < maxLength - ((String)entry.getKey()).length(); ++x) {
                pw.print(" ");
            }
            pw.println((String)entry.getValue());
        }
        pw.println("Exit commands: ");
        pw.print("  ");
        pw.println(this.join(this.exitCommands));
        pw.println("List module commands: ");
        pw.print("  ");
        pw.print(this.join(this.listCommands));
        this.getLog().info((CharSequence)writer.toString());
    }

    private String join(List<String> list) {
        StringBuffer sb = new StringBuffer();
        for (int x = 0; x < list.size(); ++x) {
            sb.append(list.get(x));
            if (x + 1 >= list.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static void parseCommand(String text, Map<String, String> aliases, List<MojoCall> commands) {
        String[] tokens = text.split(" ");
        if (tokens.length > 1) {
            for (String token : tokens) {
                ExecuteCliMojo.parseCommand(token, aliases, commands);
            }
        } else if (aliases.containsKey(text)) {
            ExecuteCliMojo.parseCommand(aliases.get(text), aliases, commands);
        } else {
            String[] parsed = text.split(":");
            if (parsed.length < 3) {
                throw new IllegalArgumentException("Invalid command: " + text);
            }
            commands.add(new MojoCall(parsed[0], parsed[1], parsed[2]));
        }
    }

    private String readCommand(ConsoleReader reader) throws IOException {
        try {
            return reader.readLine();
        }
        catch (SocketException ex) {
            return null;
        }
    }

    private static class MojoCall {
        private final String groupId;
        private final String artifactId;
        private final String goal;

        public MojoCall(String groupId, String artifactId, String goal) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.goal = goal;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getGoal() {
            return this.goal;
        }

        public String getVersion(MavenProject project) {
            String version = null;
            List plugins = project.getBuildPlugins();
            for (Plugin plugin : plugins) {
                if (!this.groupId.equals(plugin.getGroupId()) || !this.artifactId.equals(plugin.getArtifactId())) continue;
                version = plugin.getVersion();
                break;
            }
            if (version == null) {
                plugins = project.getPluginManagement().getPlugins();
                for (Plugin plugin : plugins) {
                    if (!this.groupId.equals(plugin.getGroupId()) || !this.artifactId.equals(plugin.getArtifactId())) continue;
                    version = plugin.getVersion();
                    break;
                }
            }
            if (version == null) {
                version = "RELEASE";
            }
            return version;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.groupId).append(":").append(this.artifactId);
            sb.append(" [").append(this.goal).append("]");
            return sb.toString();
        }
    }
}

