/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiOutputStream
extends OutputStream {
    List<OutputStream> outputStreams;

    public MultiOutputStream(OutputStream ... outputStreams) {
        this.outputStreams = new ArrayList<OutputStream>(Arrays.asList(outputStreams));
    }

    public void write(int b) throws IOException {
        for (int i = 0; i < this.outputStreams.size(); ++i) {
            OutputStream out = this.outputStreams.get(i);
            if (out.getClass().isAssignableFrom(PrintStream.class)) {
                if (this.checkAndWrite((PrintStream)out, b)) continue;
                this.outputStreams.remove(out);
                continue;
            }
            out.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        for (int i = 0; i < this.outputStreams.size(); ++i) {
            OutputStream out = this.outputStreams.get(i);
            if (out.getClass().isAssignableFrom(PrintStream.class)) {
                if (this.checkAndWrite((PrintStream)out, b)) continue;
                this.outputStreams.remove(out);
                continue;
            }
            out.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < this.outputStreams.size(); ++i) {
            OutputStream out = this.outputStreams.get(i);
            if (out.getClass().isAssignableFrom(PrintStream.class)) {
                if (this.checkAndWrite((PrintStream)out, b, off, len)) continue;
                this.outputStreams.remove(out);
                continue;
            }
            out.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        for (OutputStream out : this.outputStreams) {
            out.flush();
        }
    }

    public void close() throws IOException {
        for (OutputStream out : this.outputStreams) {
            out.close();
        }
    }

    private boolean checkAndWrite(PrintStream stream, int b) {
        if (stream.checkError()) {
            return false;
        }
        stream.write(b);
        return true;
    }

    private boolean checkAndWrite(PrintStream stream, byte[] b) throws IOException {
        if (stream.checkError()) {
            return false;
        }
        stream.write(b);
        return true;
    }

    private boolean checkAndWrite(PrintStream stream, byte[] b, int off, int len) throws IOException {
        if (stream.checkError()) {
            return false;
        }
        stream.write(b, off, len);
        return true;
    }

    public void addStream(OutputStream stream) {
        this.outputStreams.add(stream);
    }

    public void removeStream(OutputStream stream) {
        if (this.outputStreams.contains(stream)) {
            this.outputStreams.remove(stream);
        }
    }
}

